/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeDisplayMigrationConstant;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public final class StereotypeMigrationHelper {
    public static final String EMPTY_STRING = "";
    private static StereotypeMigrationHelper migrationHelper;
    private static StereotypeDisplayCommandExecution commandHelper;
    private static StereotypeDisplayUtil helper;

    static {
        commandHelper = StereotypeDisplayCommandExecution.getInstance();
        helper = StereotypeDisplayUtil.getInstance();
    }

    private StereotypeMigrationHelper() {
    }

    public static StereotypeMigrationHelper getInstance() {
        if (migrationHelper == null) {
            migrationHelper = new StereotypeMigrationHelper();
        }
        return migrationHelper;
    }

    public Element getOldCommentSemanticElement(View view) {
        EObject baseElement;
        Element elementSemantic = null;
        if (this.isOldComment(view) && (baseElement = NotationUtils.getEObjectValue((View)view, (String)"BASE_ELEMENT", null)) instanceof Element) {
            elementSemantic = (Element)baseElement;
        }
        return elementSemantic;
    }

    public Stereotype getStereotypeFromString(View view, String stereotypeName) {
        Stereotype stereotype = null;
        Element element = helper.getSemanticElement(view);
        stereotype = element.getAppliedStereotype(stereotypeName);
        return stereotype;
    }

    public Property getPropertyFromString(View view, Stereotype stereotype, String propertyName) {
        Property property = null;
        if (view != null && !propertyName.isEmpty()) {
            Iterator propertyIterator = stereotype.getAttributes().iterator();
            while (propertyIterator.hasNext() && property == null) {
                Property propertyTest = (Property)propertyIterator.next();
                if (!propertyTest.getName().equals(propertyName)) continue;
                property = propertyTest;
            }
        }
        return property;
    }

    public void updateVisibilityAndPersistence(View view, EObject object, boolean visible) {
        if (view != null) {
            if (view.eContainer() instanceof View && !((View)view.eContainer()).getPersistedChildren().contains((Object)view)) {
                commandHelper.setPersistency(migrationHelper.getDomain(object), view, false);
            }
            if (visible != view.isVisible()) {
                commandHelper.setVisibility(migrationHelper.getDomain(object), view, visible, false);
            }
        }
    }

    public TransactionalEditingDomain getDomain(EObject object) {
        return CommandUtil.resolveEditingDomain(object);
    }

    public EAnnotation getStereotypeEAnnotation(EModelElement view) {
        EAnnotation annotation = null;
        if (view != null) {
            annotation = view.getEAnnotation("Stereotype_Annotation");
        }
        return annotation;
    }

    public boolean hasStereotypeEAnnotation(View content) {
        return this.getStereotypeEAnnotation((EModelElement)content) != null;
    }

    public EList<Stereotype> getAppliedStereotypesFromView(View view) {
        EList list = null;
        Element element = helper.getSemanticElement(view);
        list = element.getAppliedStereotypes();
        return list;
    }

    public String getStereotypesQNToDisplay(EModelElement view) {
        EMap entries;
        String stereotypesToDisplay;
        EAnnotation eannotation = this.getStereotypeEAnnotation(view);
        if (eannotation != null && (stereotypesToDisplay = (String)(entries = eannotation.getDetails()).get((Object)"StereotypeWithQualifiedNameList")) != null) {
            return stereotypesToDisplay;
        }
        return EMPTY_STRING;
    }

    public String getStereotypesToDisplay(EModelElement view) {
        EMap entries;
        String stereotypesToDisplay;
        EAnnotation eannotation = this.getStereotypeEAnnotation(view);
        if (eannotation != null && (stereotypesToDisplay = (String)(entries = eannotation.getDetails()).get((Object)"StereotypeList")) != null) {
            return stereotypesToDisplay;
        }
        return EMPTY_STRING;
    }

    public String getAppliedStereotypesPropertiesLocalization(EModelElement view) {
        EMap entries;
        String displayLocalization;
        EAnnotation eannotation = this.getStereotypeEAnnotation(view);
        if (eannotation != null && (displayLocalization = (String)(entries = eannotation.getDetails()).get((Object)"StereotypePropertyLocation")) != null && !displayLocalization.equals("Compartment")) {
            return displayLocalization;
        }
        return "Compartment";
    }

    public String getAppliedStereotypesPropertiesToDisplay(EModelElement view) {
        EMap entries;
        String stereotypesToDisplay;
        EAnnotation eannotation = this.getStereotypeEAnnotation(view);
        if (eannotation != null && (stereotypesToDisplay = (String)(entries = eannotation.getDetails()).get((Object)"PropStereoDisplay")) != null) {
            return stereotypesToDisplay;
        }
        return EMPTY_STRING;
    }

    public boolean isOldComment(Object object) {
        if (object instanceof View) {
            View view = (View)object;
            return view.getType().equals("AppliedStereotypesComment");
        }
        return false;
    }

    public View getOldStereotypeComment(View semanticView) {
        Node node = null;
        if (semanticView != null && semanticView.getSourceEdges() != null) {
            Iterator edgeIterator = semanticView.getSourceEdges().iterator();
            Edge appliedStereotypeLink = null;
            while (edgeIterator.hasNext() && appliedStereotypeLink == null) {
                Edge edge = (Edge)edgeIterator.next();
                if (!edge.getType().equals(StereotypeDisplayMigrationConstant.OLD_COMMENT_LINK_TYPE)) continue;
                appliedStereotypeLink = edge;
            }
            if (appliedStereotypeLink == null) {
                return null;
            }
            node = (Node)appliedStereotypeLink.getTarget();
        }
        return node;
    }

    public Edge getOldStereotypeLinkComment(View semanticView) {
        Edge appliedStereotypeLink = null;
        if (semanticView != null && semanticView.getSourceEdges() != null) {
            Iterator edgeIterator = semanticView.getSourceEdges().iterator();
            while (edgeIterator.hasNext() && appliedStereotypeLink == null) {
                Edge edge = (Edge)edgeIterator.next();
                if (!edge.getType().equals(StereotypeDisplayMigrationConstant.OLD_COMMENT_LINK_TYPE)) continue;
                appliedStereotypeLink = edge;
            }
        }
        return appliedStereotypeLink;
    }

    public boolean isOrphanComment(View view) {
        Element element;
        boolean orphanComment = false;
        if (this.isOldComment(view) && ((element = this.getOldCommentSemanticElement(view)) == null || element.getAppliedStereotypes().size() == 0)) {
            orphanComment = true;
        }
        return orphanComment;
    }
}

