/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.CollaborationUseUtil;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Element;

public class CollaborationUseLabelHelper
extends StereotypedElementLabelHelper {
    private static CollaborationUseLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static CollaborationUseLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new CollaborationUseLabelHelper();
        }
        return labelHelper;
    }

    public String getMaskLabel(String value) {
        return this.masks.get(value);
    }

    public Collection<String> getMaskLabels() {
        return this.masks.values();
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    protected CollaborationUseLabelHelper() {
        this.masks.clear();
        this.masks.put("visibility", "Visibility");
        this.masks.put("name", "Name");
        this.masks.put("type", "Type");
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        CollaborationUse elem;
        Collection displayValue = ICustomAppearance.DEFAULT_UML_PROPERTY;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        if ((elem = this.getUMLElement(editPart)) != null) {
            return CollaborationUseUtil.getCustomLabel((CollaborationUse)elem, (Collection)displayValue);
        }
        return "";
    }

    public CollaborationUse getUMLElement(GraphicalEditPart editPart) {
        Element element = super.getUMLElement(editPart);
        if (element instanceof CollaborationUse) {
            return (CollaborationUse)element;
        }
        return null;
    }
}

