/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.papyrus.infra.extendedtypes.types.IExtendedHintedElementType;
import org.eclipse.papyrus.infra.extendedtypes.util.ElementTypeUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.composite.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        int visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "CompositeStructure";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "CompositeStructure".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
            } else {
                if (!"CompositeStructure".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 3121: {
                        break;
                    }
                    case 2060: 
                    case 2061: 
                    case 2062: 
                    case 2063: 
                    case 2064: 
                    case 2065: 
                    case 2066: 
                    case 2067: 
                    case 2068: 
                    case 2069: 
                    case 2070: 
                    case 2071: 
                    case 2072: 
                    case 2073: 
                    case 2075: 
                    case 2076: 
                    case 2077: 
                    case 2078: 
                    case 2079: 
                    case 2080: 
                    case 2081: 
                    case 2082: 
                    case 2083: 
                    case 2084: 
                    case 2085: 
                    case 2088: 
                    case 2089: 
                    case 2093: 
                    case 2094: 
                    case 2095: 
                    case 2096: 
                    case 2097: 
                    case 2098: 
                    case 2099: 
                    case 2100: 
                    case 2101: 
                    case 2102: 
                    case 2103: 
                    case 2104: 
                    case 2105: 
                    case 2106: 
                    case 2107: 
                    case 2108: 
                    case 2109: 
                    case 2110: 
                    case 2111: 
                    case 2112: 
                    case 2113: 
                    case 2114: 
                    case 3066: 
                    case 3069: 
                    case 3070: 
                    case 3071: 
                    case 3072: 
                    case 3073: 
                    case 3074: 
                    case 3075: 
                    case 3076: 
                    case 3077: 
                    case 3078: 
                    case 3079: 
                    case 3080: 
                    case 3081: 
                    case 3082: 
                    case 3083: 
                    case 3084: 
                    case 3085: 
                    case 3086: 
                    case 3087: 
                    case 3088: 
                    case 3091: 
                    case 3092: 
                    case 3093: 
                    case 3094: 
                    case 3095: 
                    case 3096: 
                    case 3097: 
                    case 3101: 
                    case 3102: 
                    case 3115: 
                    case 3116: 
                    case 3117: 
                    case 3118: 
                    case 3119: 
                    case 3120: {
                        if (domainElement != null && visualID == UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType closestNonExtendedType;
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType instanceof IExtendedHintedElementType ? !UMLElementTypes.isKnownElementType(closestNonExtendedType = ElementTypeUtils.getClosestDiagramType((IElementType)elementType)) || !(closestNonExtendedType instanceof IHintedType) : !UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        return elementTypeHint != null && (op.getSemanticHint() == null || elementTypeHint.equals(op.getSemanticHint()));
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramVersioningUtils.stampCurrentVersion((Diagram)diagram);
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("CompositeStructure");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2060: {
                return this.createActivity_2060(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2061: {
                return this.createInteraction_2061(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2062: {
                return this.createProtocolStateMachine_2062(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2063: {
                return this.createStateMachine_2063(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2064: {
                return this.createFunctionBehavior_2064(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2065: {
                return this.createOpaqueBehavior_2065(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2069: {
                return this.createComponent_2069(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2070: {
                return this.createDevice_2070(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2071: {
                return this.createExecutionEnvironment_2071(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2072: {
                return this.createNode_2072(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2073: {
                return this.createClass_2073(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2075: {
                return this.createCollaboration_2075(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2076: {
                return this.createInterface_2076(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2066: {
                return this.createPrimitiveType_2066(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2067: {
                return this.createEnumeration_2067(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2068: {
                return this.createDataType_2068(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2077: {
                return this.createActor_2077(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2078: {
                return this.createDeploymentSpecification_2078(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2079: {
                return this.createArtifact_2079(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2080: {
                return this.createInformationItem_2080(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2081: {
                return this.createSignal_2081(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2082: {
                return this.createUseCase_2082(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2083: {
                return this.createSignalEvent_2083(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2084: {
                return this.createCallEvent_2084(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2085: {
                return this.createAnyReceiveEvent_2085(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2088: {
                return this.createChangeEvent_2088(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2089: {
                return this.createTimeEvent_2089(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2093: {
                return this.createDurationObservation_2093(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2094: {
                return this.createTimeObservation_2094(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2095: {
                return this.createLiteralBoolean_2095(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2096: {
                return this.createLiteralInteger_2096(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2097: {
                return this.createLiteralNull_2097(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2098: {
                return this.createLiteralString_2098(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2099: {
                return this.createLiteralUnlimitedNatural_2099(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2100: {
                return this.createStringExpression_2100(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2101: {
                return this.createOpaqueExpression_2101(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2102: {
                return this.createTimeExpression_2102(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2103: {
                return this.createExpression_2103(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2104: {
                return this.createDuration_2104(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2105: {
                return this.createTimeInterval_2105(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2106: {
                return this.createDurationInterval_2106(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2107: {
                return this.createInterval_2107(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2108: {
                return this.createInstanceValue_2108(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2109: {
                return this.createComment_2109(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2110: {
                return this.createDurationConstraint_2110(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2111: {
                return this.createTimeConstraint_2111(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2112: {
                return this.createIntervalConstraint_2112(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2113: {
                return this.createInteractionConstraint_2113(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2114: {
                return this.createConstraint_2114(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3121: {
                return this.createNode_3121(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3069: {
                return this.createPort_3069(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3088: {
                return this.createParameter_3088(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3070: {
                return this.createProperty_3070(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3115: {
                return this.createConnectableElement_3115(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3071: {
                return this.createCollaborationUse_3071(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3072: {
                return this.createActivity_3072(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3073: {
                return this.createInteraction_3073(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3074: {
                return this.createProtocolStateMachine_3074(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3075: {
                return this.createStateMachine_3075(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3076: {
                return this.createFunctionBehavior_3076(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3077: {
                return this.createOpaqueBehavior_3077(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3081: {
                return this.createComponent_3081(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3082: {
                return this.createDevice_3082(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3083: {
                return this.createExecutionEnvironment_3083(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3084: {
                return this.createNode_3084(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3085: {
                return this.createClass_3085(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3086: {
                return this.createCollaboration_3086(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3087: {
                return this.createInterface_3087(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3078: {
                return this.createPrimitiveType_3078(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3079: {
                return this.createEnumeration_3079(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3080: {
                return this.createDataType_3080(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3091: {
                return this.createActor_3091(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3092: {
                return this.createDeploymentSpecification_3092(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3093: {
                return this.createArtifact_3093(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3094: {
                return this.createInformationItem_3094(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3095: {
                return this.createSignal_3095(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3096: {
                return this.createUseCase_3096(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3097: {
                return this.createComment_3097(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3116: {
                return this.createDurationConstraint_3116(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3117: {
                return this.createTimeConstraint_3117(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3118: {
                return this.createIntervalConstraint_3118(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3119: {
                return this.createInteractionConstraint_3119(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3120: {
                return this.createConstraint_3120(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3101: {
                return this.createProperty_3101(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3102: {
                return this.createOperation_3102(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3066: {
                return this.createEnumerationLiteral_3066(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (UMLVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 4022: {
                return this.createLink_4022(containerView, index, persisted, preferencesHint);
            }
            case 4001: {
                return this.createLink_4001(containerView, index, persisted, preferencesHint);
            }
            case 4002: {
                return this.createCommentAnnotatedElement_4002(containerView, index, persisted, preferencesHint);
            }
            case 4003: {
                return this.createConstraintConstrainedElement_4003(containerView, index, persisted, preferencesHint);
            }
            case 4004: {
                return this.createComponentRealization_4004(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4005: {
                return this.createInterfaceRealization_4005(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4011: {
                return this.createSubstitution_4011(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4006: {
                return this.createRealization_4006(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4012: {
                return this.createManifestation_4012(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4007: {
                return this.createAbstraction_4007(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4008: {
                return this.createUsage_4008(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4009: {
                return this.createDeployment_4009(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4017: {
                return this.createDependency_4017(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4010: {
                return this.createDependency_4010(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4013: {
                return this.createConnector_4013(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4015: {
                return this.createGeneralization_4015(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4018: {
                return this.createTimeObservationEvent_4018(containerView, index, persisted, preferencesHint);
            }
            case 4019: {
                return this.createDurationObservationEvent_4019(containerView, index, persisted, preferencesHint);
            }
            case 4020: {
                return this.createInformationItemRepresented_4020(containerView, index, persisted, preferencesHint);
            }
            case 4021: {
                return this.createInformationFlow_4021(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createActivity_2060(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2060));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Activity");
        Node label5112 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5112));
        Node label6079 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6079));
        label6079.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6079 = (Location)label6079.getLayoutConstraint();
        location6079.setX(0);
        location6079.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7063), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Activity");
        return node;
    }

    public Node createInteraction_2061(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2061));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        Node label5113 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5113));
        Node label6080 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6080));
        label6080.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6080 = (Location)label6080.getLayoutConstraint();
        location6080.setX(0);
        location6080.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7064), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        return node;
    }

    public Node createProtocolStateMachine_2062(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2062));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ProtocolStateMachine");
        Node label5114 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5114));
        Node label6081 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6081));
        label6081.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6081 = (Location)label6081.getLayoutConstraint();
        location6081.setX(0);
        location6081.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7065), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ProtocolStateMachine");
        return node;
    }

    public Node createStateMachine_2063(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2063));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        Node label5115 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5115));
        Node label6082 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6082));
        label6082.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6082 = (Location)label6082.getLayoutConstraint();
        location6082.setX(0);
        location6082.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7066), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        return node;
    }

    public Node createFunctionBehavior_2064(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2064));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FunctionBehavior");
        Node label5116 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5116));
        Node label6083 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6083));
        label6083.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6083 = (Location)label6083.getLayoutConstraint();
        location6083.setX(0);
        location6083.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7067), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FunctionBehavior");
        return node;
    }

    public Node createOpaqueBehavior_2065(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2065));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OpaqueBehavior");
        Node label5117 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5117));
        Node label6084 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6084));
        label6084.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6084 = (Location)label6084.getLayoutConstraint();
        location6084.setX(0);
        location6084.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7068), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OpaqueBehavior");
        return node;
    }

    public Node createComponent_2069(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2069));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        Node label5121 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5121));
        Node label6085 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6085));
        label6085.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6085 = (Location)label6085.getLayoutConstraint();
        location6085.setX(0);
        location6085.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7069), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        return node;
    }

    public Node createDevice_2070(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2070));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Device");
        Node label5122 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5122));
        Node label6086 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6086));
        label6086.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6086 = (Location)label6086.getLayoutConstraint();
        location6086.setX(0);
        location6086.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7070), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Device");
        return node;
    }

    public Node createExecutionEnvironment_2071(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2071));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExecutionEnvironment");
        Node label5123 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5123));
        Node label6087 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6087));
        label6087.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6087 = (Location)label6087.getLayoutConstraint();
        location6087.setX(0);
        location6087.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7071), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExecutionEnvironment");
        return node;
    }

    public Node createNode_2072(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2072));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Node");
        Node label5124 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5124));
        Node label6088 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6088));
        label6088.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6088 = (Location)label6088.getLayoutConstraint();
        location6088.setX(0);
        location6088.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7072), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Node");
        return node;
    }

    public Node createClass_2073(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2073));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Class");
        Node label5156 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5156));
        Node label6089 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6089));
        label6089.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6089 = (Location)label6089.getLayoutConstraint();
        location6089.setX(0);
        location6089.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7073), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Class");
        return node;
    }

    public Node createCollaboration_2075(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2075));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Collaboration");
        Node label5158 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5158));
        Node label6090 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6090));
        label6090.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6090 = (Location)label6090.getLayoutConstraint();
        location6090.setX(0);
        location6090.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7075), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Collaboration");
        return node;
    }

    public Node createInterface_2076(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2076));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interface");
        Node label5159 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5159));
        Node label6091 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6091));
        label6091.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6091 = (Location)label6091.getLayoutConstraint();
        location6091.setX(0);
        location6091.setY(5);
        return node;
    }

    public Node createPrimitiveType_2066(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2066));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"PrimitiveType");
        Node label5118 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5118));
        Node label6092 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6092));
        label6092.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6092 = (Location)label6092.getLayoutConstraint();
        location6092.setX(0);
        location6092.setY(5);
        return node;
    }

    public Node createEnumeration_2067(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2067));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Enumeration");
        Node label5119 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5119));
        Node label6093 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6093));
        label6093.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6093 = (Location)label6093.getLayoutConstraint();
        location6093.setX(0);
        location6093.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7048), true, true, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Enumeration");
        return node;
    }

    public Node createDataType_2068(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2068));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DataType");
        Node label5120 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5120));
        Node label6094 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6094));
        label6094.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6094 = (Location)label6094.getLayoutConstraint();
        location6094.setX(0);
        location6094.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7033), true, true, true, true);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7034), true, true, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DataType");
        return node;
    }

    public Node createActor_2077(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2077));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        Node label5160 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5160));
        Node label6095 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6095));
        label6095.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6095 = (Location)label6095.getLayoutConstraint();
        location6095.setX(0);
        location6095.setY(5);
        return node;
    }

    public Node createDeploymentSpecification_2078(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2078));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DeploymentSpecification");
        Node label5161 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5161));
        Node label6096 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6096));
        label6096.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6096 = (Location)label6096.getLayoutConstraint();
        location6096.setX(0);
        location6096.setY(5);
        return node;
    }

    public Node createArtifact_2079(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2079));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Artifact");
        Node label5162 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5162));
        Node label6097 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6097));
        label6097.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6097 = (Location)label6097.getLayoutConstraint();
        location6097.setX(0);
        location6097.setY(5);
        return node;
    }

    public Node createInformationItem_2080(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2080));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InformationItem");
        Node label5163 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5163));
        Node label6098 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6098));
        label6098.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6098 = (Location)label6098.getLayoutConstraint();
        location6098.setX(0);
        location6098.setY(5);
        return node;
    }

    public Node createSignal_2081(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2081));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Signal");
        Node label5164 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5164));
        Node label6099 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6099));
        label6099.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6099 = (Location)label6099.getLayoutConstraint();
        location6099.setX(0);
        location6099.setY(5);
        return node;
    }

    public Node createUseCase_2082(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2082));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        Node label5165 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5165));
        Node label6100 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6100));
        label6100.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6100 = (Location)label6100.getLayoutConstraint();
        location6100.setX(0);
        location6100.setY(5);
        return node;
    }

    public Node createSignalEvent_2083(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2083));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"SignalEvent");
        Node label5166 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5166));
        Node label6101 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6101));
        label6101.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6101 = (Location)label6101.getLayoutConstraint();
        location6101.setX(0);
        location6101.setY(5);
        return node;
    }

    public Node createCallEvent_2084(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2084));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CallEvent");
        Node label5167 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5167));
        Node label6102 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6102));
        label6102.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6102 = (Location)label6102.getLayoutConstraint();
        location6102.setX(0);
        location6102.setY(5);
        return node;
    }

    public Node createAnyReceiveEvent_2085(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2085));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"AnyReceiveEvent");
        Node label5168 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5168));
        Node label6103 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6103));
        label6103.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6103 = (Location)label6103.getLayoutConstraint();
        location6103.setX(0);
        location6103.setY(5);
        return node;
    }

    public Node createChangeEvent_2088(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2088));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ChangeEvent");
        Node label5171 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5171));
        Node label6104 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6104));
        label6104.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6104 = (Location)label6104.getLayoutConstraint();
        location6104.setX(0);
        location6104.setY(5);
        return node;
    }

    public Node createTimeEvent_2089(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2089));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeEvent");
        Node label5172 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5172));
        Node label6105 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6105));
        label6105.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6105 = (Location)label6105.getLayoutConstraint();
        location6105.setX(0);
        location6105.setY(5);
        return node;
    }

    public Node createDurationObservation_2093(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2093));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationObservation");
        Node label5151 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5151));
        label5151.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5151 = (Location)label5151.getLayoutConstraint();
        location5151.setX(25);
        location5151.setY(3);
        Node label5152 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5152));
        label5152.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5152 = (Location)label5152.getLayoutConstraint();
        location5152.setX(25);
        location5152.setY(-10);
        return node;
    }

    public Node createTimeObservation_2094(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2094));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        Node label5142 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5142));
        label5142.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5142 = (Location)label5142.getLayoutConstraint();
        location5142.setX(25);
        location5142.setY(3);
        Node label5143 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5143));
        label5143.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5143 = (Location)label5143.getLayoutConstraint();
        location5143.setX(25);
        location5143.setY(-10);
        return node;
    }

    public Node createLiteralBoolean_2095(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2095));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LiteralBoolean");
        Node label5178 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5178));
        Node label6106 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6106));
        label6106.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6106 = (Location)label6106.getLayoutConstraint();
        location6106.setX(0);
        location6106.setY(5);
        return node;
    }

    public Node createLiteralInteger_2096(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2096));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LiteralInteger");
        Node label5179 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5179));
        Node label6107 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6107));
        label6107.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6107 = (Location)label6107.getLayoutConstraint();
        location6107.setX(0);
        location6107.setY(5);
        return node;
    }

    public Node createLiteralNull_2097(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2097));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LiteralNull");
        Node label5180 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5180));
        Node label6108 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6108));
        label6108.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6108 = (Location)label6108.getLayoutConstraint();
        location6108.setX(0);
        location6108.setY(5);
        return node;
    }

    public Node createLiteralString_2098(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2098));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LiteralString");
        Node label5181 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5181));
        Node label6109 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6109));
        label6109.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6109 = (Location)label6109.getLayoutConstraint();
        location6109.setX(0);
        location6109.setY(5);
        return node;
    }

    public Node createLiteralUnlimitedNatural_2099(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2099));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"LiteralUnlimitedNatural");
        Node label5182 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5182));
        Node label6110 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6110));
        label6110.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6110 = (Location)label6110.getLayoutConstraint();
        location6110.setX(0);
        location6110.setY(5);
        return node;
    }

    public Node createStringExpression_2100(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2100));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StringExpression");
        Node label5183 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5183));
        Node label6111 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6111));
        label6111.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6111 = (Location)label6111.getLayoutConstraint();
        location6111.setX(0);
        location6111.setY(5);
        return node;
    }

    public Node createOpaqueExpression_2101(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2101));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OpaqueExpression");
        Node label5184 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5184));
        Node label6112 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6112));
        label6112.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6112 = (Location)label6112.getLayoutConstraint();
        location6112.setX(0);
        location6112.setY(5);
        return node;
    }

    public Node createTimeExpression_2102(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2102));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeExpression");
        Node label5185 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5185));
        Node label6113 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6113));
        label6113.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6113 = (Location)label6113.getLayoutConstraint();
        location6113.setX(0);
        location6113.setY(5);
        return node;
    }

    public Node createExpression_2103(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2103));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Expression");
        Node label5186 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5186));
        Node label6114 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6114));
        label6114.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6114 = (Location)label6114.getLayoutConstraint();
        location6114.setX(0);
        location6114.setY(5);
        return node;
    }

    public Node createDuration_2104(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2104));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Duration");
        Node label5187 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5187));
        Node label6115 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6115));
        label6115.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6115 = (Location)label6115.getLayoutConstraint();
        location6115.setX(0);
        location6115.setY(5);
        return node;
    }

    public Node createTimeInterval_2105(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2105));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeInterval");
        Node label5188 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5188));
        Node label6116 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6116));
        label6116.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6116 = (Location)label6116.getLayoutConstraint();
        location6116.setX(0);
        location6116.setY(5);
        return node;
    }

    public Node createDurationInterval_2106(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2106));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationInterval");
        Node label5189 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5189));
        Node label6117 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6117));
        label6117.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6117 = (Location)label6117.getLayoutConstraint();
        location6117.setX(0);
        location6117.setY(5);
        return node;
    }

    public Node createInterval_2107(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2107));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interval");
        Node label5190 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5190));
        Node label6118 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6118));
        label6118.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6118 = (Location)label6118.getLayoutConstraint();
        location6118.setX(0);
        location6118.setY(5);
        return node;
    }

    public Node createInstanceValue_2108(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2108));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InstanceValue");
        Node label5191 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5191));
        Node label6119 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6119));
        label6119.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6119 = (Location)label6119.getLayoutConstraint();
        location6119.setX(0);
        location6119.setY(5);
        return node;
    }

    public Node createComment_2109(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2109));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        Node label5192 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5192));
        return node;
    }

    public Node createDurationConstraint_2110(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2110));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node label5193 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5193));
        Node label6035 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6035));
        return node;
    }

    public Node createTimeConstraint_2111(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2111));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        Node label5194 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5194));
        Node label6036 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6036));
        return node;
    }

    public Node createIntervalConstraint_2112(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2112));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"IntervalConstraint");
        Node label5195 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5195));
        Node label6037 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6037));
        return node;
    }

    public Node createInteractionConstraint_2113(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2113));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionConstraint");
        Node label5196 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5196));
        Node label6038 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6038));
        return node;
    }

    public Node createConstraint_2114(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(2114));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        Node label5197 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5197));
        Node label6039 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6039));
        return node;
    }

    public Node createNode_3121(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3121));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label6053 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6053));
        label6053.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6053 = (Location)label6053.getLayoutConstraint();
        location6053.setX(0);
        location6053.setY(5);
        return node;
    }

    public Node createPort_3069(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3069));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Port");
        Node label5125 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5125));
        label5125.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location5125 = (Location)label5125.getLayoutConstraint();
        location5125.setX(25);
        location5125.setY(3);
        Node label6029 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6029));
        label6029.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6029 = (Location)label6029.getLayoutConstraint();
        location6029.setX(25);
        location6029.setY(-10);
        return node;
    }

    public Node createParameter_3088(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3088));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Parameter");
        Node label6033 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6033));
        label6033.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6033 = (Location)label6033.getLayoutConstraint();
        location6033.setX(25);
        location6033.setY(3);
        Node label6034 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6034));
        label6034.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6034 = (Location)label6034.getLayoutConstraint();
        location6034.setX(25);
        location6034.setY(-10);
        return node;
    }

    public Node createProperty_3070(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3070));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        Node label5126 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5126));
        Node label6054 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6054));
        label6054.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6054 = (Location)label6054.getLayoutConstraint();
        location6054.setX(0);
        location6054.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7077), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        return node;
    }

    public Node createConnectableElement_3115(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3115));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CollaborationRole");
        Node label5198 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5198));
        Node label6055 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6055));
        label6055.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6055 = (Location)label6055.getLayoutConstraint();
        location6055.setX(0);
        location6055.setY(5);
        return node;
    }

    public Node createCollaborationUse_3071(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3071));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CollaborationUse");
        Node label5127 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5127));
        Node label6056 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6056));
        label6056.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6056 = (Location)label6056.getLayoutConstraint();
        location6056.setX(0);
        location6056.setY(5);
        return node;
    }

    public Node createActivity_3072(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3072));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Activity");
        Node label5128 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5128));
        Node label6057 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6057));
        label6057.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6057 = (Location)label6057.getLayoutConstraint();
        location6057.setX(0);
        location6057.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7050), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Activity");
        return node;
    }

    public Node createInteraction_3073(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3073));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        Node label5129 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5129));
        Node label6058 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6058));
        label6058.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6058 = (Location)label6058.getLayoutConstraint();
        location6058.setX(0);
        location6058.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7051), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        return node;
    }

    public Node createProtocolStateMachine_3074(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3074));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ProtocolStateMachine");
        Node label5130 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5130));
        Node label6059 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6059));
        label6059.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6059 = (Location)label6059.getLayoutConstraint();
        location6059.setX(0);
        location6059.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7052), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ProtocolStateMachine");
        return node;
    }

    public Node createStateMachine_3075(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3075));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        Node label5131 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5131));
        Node label6060 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6060));
        label6060.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6060 = (Location)label6060.getLayoutConstraint();
        location6060.setX(0);
        location6060.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7053), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateMachine");
        return node;
    }

    public Node createFunctionBehavior_3076(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3076));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FunctionBehavior");
        Node label5132 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5132));
        Node label6061 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6061));
        label6061.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6061 = (Location)label6061.getLayoutConstraint();
        location6061.setX(0);
        location6061.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7054), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"FunctionBehavior");
        return node;
    }

    public Node createOpaqueBehavior_3077(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3077));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OpaqueBehavior");
        Node label5133 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5133));
        Node label6062 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6062));
        label6062.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6062 = (Location)label6062.getLayoutConstraint();
        location6062.setX(0);
        location6062.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7055), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"OpaqueBehavior");
        return node;
    }

    public Node createComponent_3081(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3081));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        Node label5137 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5137));
        Node label6063 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6063));
        label6063.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6063 = (Location)label6063.getLayoutConstraint();
        location6063.setX(0);
        location6063.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7056), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Component");
        return node;
    }

    public Node createDevice_3082(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3082));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Device");
        Node label5138 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5138));
        Node label6064 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6064));
        label6064.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6064 = (Location)label6064.getLayoutConstraint();
        location6064.setX(0);
        location6064.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7057), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Device");
        return node;
    }

    public Node createExecutionEnvironment_3083(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3083));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExecutionEnvironment");
        Node label5139 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5139));
        Node label6065 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6065));
        label6065.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6065 = (Location)label6065.getLayoutConstraint();
        location6065.setX(0);
        location6065.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7058), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ExecutionEnvironment");
        return node;
    }

    public Node createNode_3084(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3084));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Node");
        Node label5140 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5140));
        Node label6066 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6066));
        label6066.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6066 = (Location)label6066.getLayoutConstraint();
        location6066.setX(0);
        location6066.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7059), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Node");
        return node;
    }

    public Node createClass_3085(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3085));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Class");
        Node label5155 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5155));
        Node label6067 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6067));
        label6067.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6067 = (Location)label6067.getLayoutConstraint();
        location6067.setX(0);
        location6067.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7060), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Class");
        return node;
    }

    public Node createCollaboration_3086(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3086));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Collaboration");
        Node label5141 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5141));
        Node label6068 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6068));
        label6068.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6068 = (Location)label6068.getLayoutConstraint();
        location6068.setX(0);
        location6068.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7061), true, true, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Collaboration");
        return node;
    }

    public Node createInterface_3087(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3087));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interface");
        Node label5154 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5154));
        Node label6069 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6069));
        label6069.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6069 = (Location)label6069.getLayoutConstraint();
        location6069.setX(0);
        location6069.setY(5);
        return node;
    }

    public Node createPrimitiveType_3078(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3078));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"PrimitiveType");
        Node label5134 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5134));
        Node label6070 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6070));
        label6070.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6070 = (Location)label6070.getLayoutConstraint();
        location6070.setX(0);
        location6070.setY(5);
        return node;
    }

    public Node createEnumeration_3079(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3079));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Enumeration");
        Node label5135 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5135));
        Node label6071 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6071));
        label6071.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6071 = (Location)label6071.getLayoutConstraint();
        location6071.setX(0);
        location6071.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7049), true, true, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Enumeration");
        return node;
    }

    public Node createDataType_3080(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3080));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DataType");
        Node label5136 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5136));
        Node label6072 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6072));
        label6072.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6072 = (Location)label6072.getLayoutConstraint();
        location6072.setX(0);
        location6072.setY(5);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7036), true, true, true, true);
        this.createCompartment((View)node, UMLVisualIDRegistry.getType(7037), true, true, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DataType");
        return node;
    }

    public Node createActor_3091(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3091));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Actor");
        Node label5144 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5144));
        Node label6073 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6073));
        label6073.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6073 = (Location)label6073.getLayoutConstraint();
        location6073.setX(0);
        location6073.setY(5);
        return node;
    }

    public Node createDeploymentSpecification_3092(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3092));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DeploymentSpecification");
        Node label5145 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5145));
        Node label6074 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6074));
        label6074.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6074 = (Location)label6074.getLayoutConstraint();
        location6074.setX(0);
        location6074.setY(5);
        return node;
    }

    public Node createArtifact_3093(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3093));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Artifact");
        Node label5146 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5146));
        Node label6075 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6075));
        label6075.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6075 = (Location)label6075.getLayoutConstraint();
        location6075.setX(0);
        location6075.setY(5);
        return node;
    }

    public Node createInformationItem_3094(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3094));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InformationItem");
        Node label5147 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5147));
        Node label6076 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6076));
        label6076.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6076 = (Location)label6076.getLayoutConstraint();
        location6076.setX(0);
        location6076.setY(5);
        return node;
    }

    public Node createSignal_3095(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3095));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Signal");
        Node label5148 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5148));
        Node label6077 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6077));
        label6077.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6077 = (Location)label6077.getLayoutConstraint();
        location6077.setX(0);
        location6077.setY(5);
        return node;
    }

    public Node createUseCase_3096(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3096));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"UseCase");
        Node label5149 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5149));
        Node label6078 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6078));
        label6078.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6078 = (Location)label6078.getLayoutConstraint();
        location6078.setX(0);
        location6078.setY(5);
        return node;
    }

    public Node createComment_3097(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3097));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        Node label5150 = this.createLabel((View)node, UMLVisualIDRegistry.getType(5150));
        return node;
    }

    public Node createDurationConstraint_3116(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3116));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node label6040 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6040));
        Node label6041 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6041));
        return node;
    }

    public Node createTimeConstraint_3117(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3117));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        Node label6042 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6042));
        Node label6043 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6043));
        return node;
    }

    public Node createIntervalConstraint_3118(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3118));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"IntervalConstraint");
        Node label6044 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6044));
        Node label6045 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6045));
        return node;
    }

    public Node createInteractionConstraint_3119(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3119));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionConstraint");
        Node label6046 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6046));
        Node label6047 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6047));
        return node;
    }

    public Node createConstraint_3120(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType(3120));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        Node label6048 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6048));
        Node label6049 = this.createLabel((View)node, UMLVisualIDRegistry.getType(6049));
        return node;
    }

    public Node createProperty_3101(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(3101));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Property");
        return node;
    }

    public Node createOperation_3102(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(3102));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Operation");
        return node;
    }

    public Node createEnumerationLiteral_3066(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        node.setType(UMLVisualIDRegistry.getType(3066));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"EnumerationLiteral");
        return node;
    }

    public Edge createLink_4022(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4022));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return edge;
    }

    public Edge createLink_4001(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4001));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return edge;
    }

    public Edge createCommentAnnotatedElement_4002(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4002));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"CommentAnnotatedElement");
        return edge;
    }

    public Edge createConstraintConstrainedElement_4003(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4003));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"ConstraintConstrainedElement");
        return edge;
    }

    public Edge createComponentRealization_4004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4004));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"ComponentRealization");
        Node label6001 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6001));
        label6001.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6001 = (Location)label6001.getLayoutConstraint();
        location6001.setX(0);
        location6001.setY(60);
        Node label6015 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6015));
        label6015.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6015 = (Location)label6015.getLayoutConstraint();
        location6015.setX(0);
        location6015.setY(30);
        return edge;
    }

    public Edge createInterfaceRealization_4005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4005));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"InterfaceRealization");
        Node label6002 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6002));
        label6002.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6002 = (Location)label6002.getLayoutConstraint();
        location6002.setX(0);
        location6002.setY(60);
        Node label6016 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6016));
        label6016.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6016 = (Location)label6016.getLayoutConstraint();
        location6016.setX(0);
        location6016.setY(30);
        return edge;
    }

    public Edge createSubstitution_4011(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4011));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Substitution");
        Node label6003 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6003));
        label6003.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6003 = (Location)label6003.getLayoutConstraint();
        location6003.setX(0);
        location6003.setY(60);
        Node label6017 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6017));
        label6017.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6017 = (Location)label6017.getLayoutConstraint();
        location6017.setX(0);
        location6017.setY(30);
        return edge;
    }

    public Edge createRealization_4006(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4006));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Realization");
        Node label6004 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6004));
        label6004.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6004 = (Location)label6004.getLayoutConstraint();
        location6004.setX(0);
        location6004.setY(60);
        Node label6018 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6018));
        label6018.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6018 = (Location)label6018.getLayoutConstraint();
        location6018.setX(0);
        location6018.setY(30);
        return edge;
    }

    public Edge createManifestation_4012(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4012));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Manifestation");
        Node label6005 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6005));
        label6005.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6005 = (Location)label6005.getLayoutConstraint();
        location6005.setX(0);
        location6005.setY(60);
        Node label6019 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6019));
        label6019.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6019 = (Location)label6019.getLayoutConstraint();
        location6019.setX(0);
        location6019.setY(30);
        return edge;
    }

    public Edge createAbstraction_4007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4007));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Abstraction");
        Node label6006 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6006));
        label6006.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6006 = (Location)label6006.getLayoutConstraint();
        location6006.setX(0);
        location6006.setY(60);
        Node label6020 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6020));
        label6020.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6020 = (Location)label6020.getLayoutConstraint();
        location6020.setX(0);
        location6020.setY(30);
        return edge;
    }

    public Edge createUsage_4008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4008));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Usage");
        Node label6007 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6007));
        label6007.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6007 = (Location)label6007.getLayoutConstraint();
        location6007.setX(0);
        location6007.setY(60);
        Node label6021 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6021));
        label6021.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6021 = (Location)label6021.getLayoutConstraint();
        location6021.setX(0);
        location6021.setY(30);
        return edge;
    }

    public Edge createDeployment_4009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4009));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Deployment");
        Node label6008 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6008));
        label6008.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6008 = (Location)label6008.getLayoutConstraint();
        location6008.setX(0);
        location6008.setY(60);
        Node label6022 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6022));
        label6022.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6022 = (Location)label6022.getLayoutConstraint();
        location6022.setX(0);
        location6022.setY(30);
        return edge;
    }

    public Edge createDependency_4017(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4017));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"RoleBinding");
        Node label6027 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6027));
        label6027.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6027 = (Location)label6027.getLayoutConstraint();
        location6027.setX(0);
        location6027.setY(20);
        Node label6028 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6028));
        label6028.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6028 = (Location)label6028.getLayoutConstraint();
        location6028.setX(0);
        location6028.setY(60);
        return edge;
    }

    public Edge createDependency_4010(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4010));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Dependency");
        Node label6009 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6009));
        label6009.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6009 = (Location)label6009.getLayoutConstraint();
        location6009.setX(0);
        location6009.setY(60);
        Node label6023 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6023));
        label6023.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6023 = (Location)label6023.getLayoutConstraint();
        location6023.setX(0);
        location6023.setY(60);
        return edge;
    }

    public Edge createConnector_4013(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4013));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Connector");
        Node label6025 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6025));
        label6025.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6025 = (Location)label6025.getLayoutConstraint();
        location6025.setX(0);
        location6025.setY(60);
        Node label6050 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6050));
        label6050.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6050 = (Location)label6050.getLayoutConstraint();
        location6050.setX(0);
        location6050.setY(-20);
        Node label6051 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6051));
        label6051.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6051 = (Location)label6051.getLayoutConstraint();
        location6051.setX(0);
        location6051.setY(20);
        Node label6052 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6052));
        label6052.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6052 = (Location)label6052.getLayoutConstraint();
        location6052.setX(0);
        location6052.setY(20);
        return edge;
    }

    public Edge createGeneralization_4015(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4015));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Generalization");
        Node label6024 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6024));
        label6024.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6024 = (Location)label6024.getLayoutConstraint();
        location6024.setX(0);
        location6024.setY(60);
        return edge;
    }

    public Edge createTimeObservationEvent_4018(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4018));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"TimeObservationEvent");
        return edge;
    }

    public Edge createDurationObservationEvent_4019(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4019));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"DurationObservationEvent");
        return edge;
    }

    public Edge createInformationItemRepresented_4020(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4020));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.colorToInteger((Color)ColorConstants.black));
        Node label6030 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6030));
        label6030.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6030 = (Location)label6030.getLayoutConstraint();
        location6030.setX(0);
        location6030.setY(15);
        return edge;
    }

    public Edge createInformationFlow_4021(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType(4021));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"InformationFlow");
        Node label6031 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6031));
        label6031.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6031 = (Location)label6031.getLayoutConstraint();
        location6031.setX(0);
        location6031.setY(30);
        Node label6032 = this.createLabel((View)edge, UMLVisualIDRegistry.getType(6032));
        label6032.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location location6032 = (Location)label6032.getLayoutConstraint();
        location6032.setX(0);
        location6032.setY(15);
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"CompositeStructure".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"CompositeStructure");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private void initFontStyleFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fontConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)1);
        String fontColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)2);
        FontStyle viewFontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (viewFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)store, (String)fontConstant);
            viewFontStyle.setFontName(fontData.getName());
            viewFontStyle.setFontHeight(fontData.getHeight());
            viewFontStyle.setBold((fontData.getStyle() & 1) != 0);
            viewFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fontColorConstant);
            viewFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
    }

    private void initForegroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String lineColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)3);
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)lineColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
    }

    private void initBackgroundFromPrefs(View view, IPreferenceStore store, String elementName) {
        String fillColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)0);
        String gradientColorConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)4);
        String gradientPolicyConstant = PreferencesConstantsHelper.getElementConstant((String)elementName, (int)5);
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)fillColorConstant);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        FillStyle fillStyle = (FillStyle)view.getStyle(NotationPackage.Literals.FILL_STYLE);
        fillStyle.setFillColor(FigureUtilities.RGBToInteger((RGB)fillRGB).intValue());
        if (store.getBoolean(gradientPolicyConstant)) {
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(store.getString(gradientColorConstant));
            fillStyle.setGradient(gradientPreferenceConverter.getGradientData());
            fillStyle.setTransparency(gradientPreferenceConverter.getTransparency());
        }
    }
}

