/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.deployment/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLDeploymentDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return 1000;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (!UMLPackage.eINSTANCE.getNamedElement().isSuperTypeOf(domainElement.eClass())) break;
                return 2012;
            }
            case 51: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 49;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 36;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 44;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 46;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 42;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 40;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 54;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 56;
            }
            case 38: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 49;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 36;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 40;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 44;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 46;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 42;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 54;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 56;
            }
            case 17: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 18: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 25;
            }
            case 19: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 25;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 26: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
            case 52: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 49;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 36;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 44;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 46;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 42;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 40;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 54;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 56;
            }
            case 39: {
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 36;
                }
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 40;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 44;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 46;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 42;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 54;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 56;
            }
            case 30: {
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (!UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 23;
            }
            case 31: {
                if (UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) {
                    return 25;
                }
                if (!UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) break;
                return 21;
            }
            case 32: {
                if (UMLPackage.eINSTANCE.getDevice().isSuperTypeOf(domainElement.eClass())) {
                    return 16;
                }
                if (UMLPackage.eINSTANCE.getExecutionEnvironment().isSuperTypeOf(domainElement.eClass())) {
                    return 21;
                }
                if (UMLPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) {
                    return 23;
                }
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 25;
            }
            case 33: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
            case 34: {
                if (!UMLPackage.eINSTANCE.getArtifact().isSuperTypeOf(domainElement.eClass())) break;
                return 28;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLDeploymentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2010 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2012 != nodeVisualID) break;
                return true;
            }
            case 2011: {
                if (7 != nodeVisualID) break;
                return true;
            }
            case 2010: {
                if (48 == nodeVisualID) {
                    return true;
                }
                if (51 != nodeVisualID) break;
                return true;
            }
            case 2009: {
                if (35 == nodeVisualID) {
                    return true;
                }
                if (38 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (2 == nodeVisualID) {
                    return true;
                }
                if (3 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (1 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5 == nodeVisualID) {
                    return true;
                }
                if (18 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (6 == nodeVisualID) {
                    return true;
                }
                if (17 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (8 == nodeVisualID) {
                    return true;
                }
                if (61 == nodeVisualID) {
                    return true;
                }
                if (26 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (9 == nodeVisualID) {
                    return true;
                }
                if (19 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (53 != nodeVisualID) break;
                return true;
            }
            case 49: {
                if (50 == nodeVisualID) {
                    return true;
                }
                if (52 != nodeVisualID) break;
                return true;
            }
            case 36: {
                if (37 == nodeVisualID) {
                    return true;
                }
                if (39 != nodeVisualID) break;
                return true;
            }
            case 16: {
                if (20 != nodeVisualID) break;
                return true;
            }
            case 44: {
                if (45 == nodeVisualID) {
                    return true;
                }
                if (30 != nodeVisualID) break;
                return true;
            }
            case 21: {
                if (22 != nodeVisualID) break;
                return true;
            }
            case 46: {
                if (47 == nodeVisualID) {
                    return true;
                }
                if (31 != nodeVisualID) break;
                return true;
            }
            case 23: {
                if (24 != nodeVisualID) break;
                return true;
            }
            case 42: {
                if (43 == nodeVisualID) {
                    return true;
                }
                if (32 != nodeVisualID) break;
                return true;
            }
            case 25: {
                if (27 == nodeVisualID) {
                    return true;
                }
                if (59 == nodeVisualID) {
                    return true;
                }
                if (33 != nodeVisualID) break;
                return true;
            }
            case 28: {
                if (29 == nodeVisualID) {
                    return true;
                }
                if (60 == nodeVisualID) {
                    return true;
                }
                if (34 != nodeVisualID) break;
                return true;
            }
            case 40: {
                if (41 != nodeVisualID) break;
                return true;
            }
            case 54: {
                if (55 != nodeVisualID) break;
                return true;
            }
            case 56: {
                if (57 == nodeVisualID) {
                    return true;
                }
                if (58 != nodeVisualID) break;
                return true;
            }
            case 51: {
                if (49 == nodeVisualID) {
                    return true;
                }
                if (36 == nodeVisualID) {
                    return true;
                }
                if (44 == nodeVisualID) {
                    return true;
                }
                if (46 == nodeVisualID) {
                    return true;
                }
                if (42 == nodeVisualID) {
                    return true;
                }
                if (40 == nodeVisualID) {
                    return true;
                }
                if (54 == nodeVisualID) {
                    return true;
                }
                if (56 != nodeVisualID) break;
                return true;
            }
            case 38: {
                if (49 == nodeVisualID) {
                    return true;
                }
                if (36 == nodeVisualID) {
                    return true;
                }
                if (40 == nodeVisualID) {
                    return true;
                }
                if (44 == nodeVisualID) {
                    return true;
                }
                if (46 == nodeVisualID) {
                    return true;
                }
                if (42 == nodeVisualID) {
                    return true;
                }
                if (54 == nodeVisualID) {
                    return true;
                }
                if (56 != nodeVisualID) break;
                return true;
            }
            case 17: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 18: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (25 != nodeVisualID) break;
                return true;
            }
            case 19: {
                if (16 == nodeVisualID) {
                    return true;
                }
                if (21 == nodeVisualID) {
                    return true;
                }
                if (25 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 26: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 52: {
                if (49 == nodeVisualID) {
                    return true;
                }
                if (36 == nodeVisualID) {
                    return true;
                }
                if (44 == nodeVisualID) {
                    return true;
                }
                if (46 == nodeVisualID) {
                    return true;
                }
                if (42 == nodeVisualID) {
                    return true;
                }
                if (40 == nodeVisualID) {
                    return true;
                }
                if (54 == nodeVisualID) {
                    return true;
                }
                if (56 != nodeVisualID) break;
                return true;
            }
            case 39: {
                if (36 == nodeVisualID) {
                    return true;
                }
                if (40 == nodeVisualID) {
                    return true;
                }
                if (44 == nodeVisualID) {
                    return true;
                }
                if (46 == nodeVisualID) {
                    return true;
                }
                if (42 == nodeVisualID) {
                    return true;
                }
                if (54 == nodeVisualID) {
                    return true;
                }
                if (56 != nodeVisualID) break;
                return true;
            }
            case 30: {
                if (21 == nodeVisualID) {
                    return true;
                }
                if (16 == nodeVisualID) {
                    return true;
                }
                if (23 != nodeVisualID) break;
                return true;
            }
            case 31: {
                if (25 == nodeVisualID) {
                    return true;
                }
                if (21 != nodeVisualID) break;
                return true;
            }
            case 32: {
                if (16 == nodeVisualID) {
                    return true;
                }
                if (21 == nodeVisualID) {
                    return true;
                }
                if (23 == nodeVisualID) {
                    return true;
                }
                if (25 != nodeVisualID) break;
                return true;
            }
            case 33: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 34: {
                if (28 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (13 == nodeVisualID) {
                    return true;
                }
                if (14 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (10 == nodeVisualID) {
                    return true;
                }
                if (11 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (4 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (12 == nodeVisualID) {
                    return true;
                }
                if (15 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getDeployment().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getCommunicationPath().isSuperTypeOf(domainElement.eClass())) {
            return 4011;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 16: 
            case 21: 
            case 23: 
            case 40: 
            case 54: 
            case 56: 
            case 2001: 
            case 2005: 
            case 2011: 
            case 2012: {
                return true;
            }
        }
        return false;
    }
}

