/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.RequestUtils;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.dnd.strategy.instancespecification.command.SelectAndCreateSlotsCommand;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierToSlotsDropStrategy
extends TransactionalDropStrategy {
    private static final EStructuralFeature feature = UMLPackage.eINSTANCE.getInstanceSpecification_Classifier();

    public String getLabel() {
        return "Type instance specification";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.instanceSpecification";
    }

    public String getDescription() {
        return "Sets the dropped classifiers as classifiers for the target InstanceSpecification. Slots corresponding to the classifiers' properties are also created.";
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (request instanceof AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        EObject semanticElement = this.getTargetSemanticElement(targetEditPart);
        List sourceElements = this.getSourceEObjects(request);
        ArrayList<Classifier> valuesToAdd = new ArrayList<Classifier>(sourceElements.size());
        for (EObject sourceElement : sourceElements) {
            if (!(sourceElement instanceof Classifier)) {
                return null;
            }
            valuesToAdd.add((Classifier)sourceElement);
        }
        if (!(semanticElement instanceof InstanceSpecification)) {
            return null;
        }
        List currentValues = (List)semanticElement.eGet(feature);
        LinkedList<Classifier> values = new LinkedList<Classifier>();
        values.addAll(currentValues);
        values.addAll(valuesToAdd);
        SetRequest setClassifiersRequest = new SetRequest(semanticElement, feature, values);
        SetValueCommand setClassifiersCommand = new SetValueCommand(setClassifiersRequest);
        cc.add((IUndoableOperation)setClassifiersCommand);
        ICommand editSlotsCommand = this.getEditSlotsCommand(valuesToAdd, targetEditPart, request);
        if (editSlotsCommand != null) {
            cc.add((IUndoableOperation)editSlotsCommand);
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }

    protected ICommand getEditSlotsCommand(List<Classifier> classifiers, EditPart targetEditPart, Request request) {
        for (Classifier classifier : classifiers) {
            if (classifier.getAllAttributes().isEmpty()) continue;
            boolean headless = !RequestUtils.useGUI((Request)request);
            return new SelectAndCreateSlotsCommand(classifiers, targetEditPart, headless);
        }
        return null;
    }

    @Deprecated
    protected ICommand getEditSlotsCommand(List<Classifier> classifiers, EditPart targetEditPart) {
        for (Classifier classifier : classifiers) {
            if (classifier.getAllAttributes().isEmpty()) continue;
            return new SelectAndCreateSlotsCommand(classifiers, targetEditPart);
        }
        return null;
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.dnd.classifierToInstanceSpecification";
    }

    public String getCategoryLabel() {
        return "Drop a Classifier on an InstanceSpecification";
    }
}

