/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.provider;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.providers.CustomUMLViewProvider;
import org.eclipse.papyrus.uml.diagram.interactionoverview.Activator;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.ElementTypes;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.GraphicalTypeRegistry;
import org.eclipse.papyrus.uml.diagram.interactionoverview.provider.IGraphicalTypeRegistry;

public class InheritedActivityDiagramViewProvider
extends CustomUMLViewProvider {
    protected IGraphicalTypeRegistry registry = new GraphicalTypeRegistry();

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge createdEdge = null;
        IElementType elementType = (IElementType)semanticAdapter.getAdapter(IElementType.class);
        if (elementType != null) {
            createdEdge = super.createEdge(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        } else {
            EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
            String domainElementGraphicalType = semanticHint;
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                if (ElementTypes.COMMENT_ANNOTATED_ELEMENT.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createCommentAnnotatedElement_4006(containerView, index, persisted, preferencesHint);
                }
                if (ElementTypes.CONTROL_FLOW.getSemanticHint().equals(domainElementGraphicalType)) {
                    createdEdge = this.createControlFlow_4004(domainElement, containerView, index, persisted, preferencesHint);
                }
            }
        }
        if (createdEdge == null) {
            Activator.log.error((Throwable)new Exception("Could not create Edge."));
        }
        return createdEdge;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String diagramType = op.getContainerView().getDiagram().getType();
        return "PapyrusUMLInteractionOverviewDiagram".equals(diagramType);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"PapyrusUMLInteractionOverviewDiagram".equals(diagramType)) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (elementType == ElementTypes.COMMENT_ANNOTATED_ELEMENT) {
            return true;
        }
        if (elementType == ElementTypes.CONTROL_FLOW) {
            return true;
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            if (domainElementGraphicalType == null) {
                domainElementGraphicalType = this.registry.getEdgeGraphicalType(domainElement);
            }
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownEdgeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        if (op.getContainerView() == null) {
            return false;
        }
        String containerGraphicalType = op.getContainerView().getType();
        String diagramType = op.getContainerView().getDiagram().getType();
        if (!"PapyrusUMLInteractionOverviewDiagram".equals(diagramType)) {
            return false;
        }
        IElementType elementType = (IElementType)op.getSemanticAdapter().getAdapter(IElementType.class);
        if (elementType == ElementTypes.ACTIVITY_FINAL_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CALL_BEHAVIOR_ACTION_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.COMMENT_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CONDITIONAL_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.DECISION_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.FLOW_FINAL_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.FORK_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.INITIAL_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.JOIN_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.LOOP_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.MERGE_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.ACTIVITY && "PapyrusUMLInteractionOverviewDiagram".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.SEQUENCE_NODE_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.CONSTRAINT_CN) {
            if ("7004".equals(containerGraphicalType)) {
                return true;
            }
            if ("7008".equals(containerGraphicalType)) {
                return true;
            }
            if ("7010".equals(containerGraphicalType)) {
                return true;
            }
            if ("7012".equals(containerGraphicalType)) {
                return true;
            }
        }
        if (elementType == ElementTypes.ACTIVITY_PARAMETER_CLN && "7001".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.ACTIVITY_CONSTRAINT_CLN && "7002".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == ElementTypes.ACTIVITY_CONSTRAINT_CLN && "7003".equals(containerGraphicalType)) {
            return true;
        }
        if (elementType == null) {
            EObject domainElement = (EObject)op.getSemanticAdapter().getAdapter(EObject.class);
            String domainElementGraphicalType = op.getSemanticHint();
            domainElementGraphicalType = domainElementGraphicalType == null ? this.registry.getNodeGraphicalType(domainElement, containerGraphicalType) : this.registry.getNodeGraphicalType(domainElementGraphicalType, containerGraphicalType);
            if (!"undefined_type".equals(domainElementGraphicalType) && this.registry.isKnownNodeType(domainElementGraphicalType)) {
                return true;
            }
        }
        return false;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        if (semanticHint != null) {
            return super.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
        }
        String containerGraphicalType = containerView.getType();
        EObject domainElement = (EObject)semanticAdapter.getAdapter(EObject.class);
        String domainElementGraphicalType = this.registry.getNodeGraphicalType(domainElement, containerGraphicalType);
        if (!"undefined_type".equals(domainElementGraphicalType)) {
            return super.createNode(semanticAdapter, containerView, domainElementGraphicalType, index, persisted, preferencesHint);
        }
        Activator.log.error((Throwable)new Exception("Could not create Node."));
        return null;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLInteractionOverviewDiagram".equals(containerView.getDiagram().getType())) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLInteractionOverviewDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }
}

