/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    public static final String GRAPHICAL_RECONNECTED_EDGE = "graphical_edge";
    private final IElementType myElementType;

    protected UMLBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(UMLVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
            request.getExtendedData().put(GRAPHICAL_RECONNECTED_EDGE, view);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(this.getEditingDomain(), (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                command = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    protected IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = UMLElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        ICommand command;
        IElementEditService commandProvider;
        IElementType requestElementType = req.getElementType();
        if (requestElementType instanceof IElementType && (commandProvider = ElementEditServiceUtils.getCommandProvider((Object)req.getContainer())) != null && (command = commandProvider.getEditCommand((IEditCommandRequest)req)) != null && command.canExecute()) {
            return new ICommandProxy(command);
        }
        return null;
    }

    protected Command getExtendedTypeCreationCommand(CreateElementRequest request, IElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)request.getContainer());
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedStartCreateRelationshipCommand(CreateElementRequest request, IElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getExtendedCompleteCreateRelationshipCommand(CreateElementRequest request, IElementType requestElementType) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)requestElementType);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)request);
        return this.getGEFWrapper(createGMFCommand);
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        EObject targetCEObject = req.getTargetContainer();
        if (targetCEObject != null) {
            ICommand moveCommand;
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetCEObject);
            if (provider != null && (moveCommand = provider.getEditCommand((IEditCommandRequest)req)) != null) {
                return new ICommandProxy(moveCommand);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return this.getGEFWrapper((ICommand)new MoveElementsCommand(req));
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return cmd == null ? UnexecutableCommand.INSTANCE : new ICommandProxy(cmd);
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected void addDestroyShortcutsCommand(ICompositeCommand cmd, View view) {
        assert (view.getEAnnotation("Shortcut") == null);
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            cmd.add((IUndoableOperation)new DeleteCommand(this.getEditingDomain(), nextView));
        }
    }

    public static LinkConstraints getLinkConstraints() {
        LinkConstraints cached = UMLDiagramEditorPlugin.getInstance().getLinkConstraints();
        if (cached == null) {
            cached = new LinkConstraints();
            UMLDiagramEditorPlugin.getInstance().setLinkConstraints(cached);
        }
        return cached;
    }

    public static class LinkConstraints {
        public boolean canCreateExtension_1013(Package container, Property source, Class target) {
            return this.canExistExtension_1013(container, null, source, target);
        }

        public boolean canCreateAssociation_4001(Package container, Type source, Type target) {
            return this.canExistAssociation_4001(container, null, source, target);
        }

        public boolean canCreateProfileApplication_1045(Package container, Package source, Profile target) {
            return this.canExistProfileApplication_1045(container, null, source, target);
        }

        public boolean canCreateAssociation_4019(Package container, Type source, Type target) {
            return this.canExistAssociation_4019(container, null, source, target);
        }

        public boolean canCreateGeneralization_4002(Classifier source, Classifier target) {
            return this.canExistGeneralization_4002(null, source, target);
        }

        public boolean canCreateDependency_4008(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4008(container, null, source, target);
        }

        public boolean canCreateDependency_4018(Package container, NamedElement source, NamedElement target) {
            return this.canExistDependency_4018(container, null, source, target);
        }

        public boolean canCreateElementImport_1064(Namespace container, Namespace source, PackageableElement target) {
            return this.canExistElementImport_1064(container, null, source, target);
        }

        public boolean canCreatePackageImport_1065(Namespace container, Namespace source, Package target) {
            return this.canExistPackageImport_1065(container, null, source, target);
        }

        public boolean canCreateCommentAnnotatedElement_1022(Comment source, Element target) {
            if (source != null && source.getAnnotatedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistCommentAnnotatedElement_1022(source, target);
        }

        public boolean canCreateConstraintConstrainedElement_4014(Constraint source, Element target) {
            if (source != null && source.getConstrainedElements().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraintConstrainedElement_4014(source, target);
        }

        public boolean canCreateConstraintContext_8500(Constraint source, Namespace target) {
            if (source != null && source.getContext() != null) {
                return false;
            }
            if (target != null && target.getOwnedRules().contains((Object)target)) {
                return false;
            }
            return this.canExistConstraintContext_8500(source, target);
        }

        public boolean canExistExtension_1013(Package container, Extension linkInstance, Property source, Class target) {
            return true;
        }

        public boolean canExistAssociation_4001(Package container, Association linkInstance, Type source, Type target) {
            block5: {
                block4: {
                    try {
                        if (!(source instanceof Type) || !Util.isMetaclass((Type)source)) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                        return false;
                    }
                }
                if (!(source instanceof Extension)) break block5;
                return false;
            }
            return target == null || !(target instanceof Extension);
        }

        public boolean canExistProfileApplication_1045(Package container, ProfileApplication linkInstance, Package source, Profile target) {
            return true;
        }

        public boolean canExistAssociation_4019(Package container, Association linkInstance, Type source, Type target) {
            block5: {
                block4: {
                    try {
                        if (!(source instanceof Type) || !Util.isMetaclass((Type)source)) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                        return false;
                    }
                }
                if (!(source instanceof Extension)) break block5;
                return false;
            }
            return target == null || !(target instanceof Extension);
        }

        public boolean canExistGeneralization_4002(Generalization linkInstance, Classifier source, Classifier target) {
            block10: {
                block12: {
                    block11: {
                        block9: {
                            block8: {
                                block7: {
                                    try {
                                        if (source instanceof Classifier) break block7;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                                        return false;
                                    }
                                }
                                if (!Util.isMetaclass((Type)source)) break block8;
                                return false;
                            }
                            if (!(source instanceof Extension)) break block9;
                            return false;
                        }
                        if (target == null) break block10;
                        if (target instanceof Classifier) break block11;
                        return false;
                    }
                    if (!Util.isMetaclass((Type)target)) break block12;
                    return false;
                }
                if (!(target instanceof Extension)) break block10;
                return false;
            }
            return true;
        }

        public boolean canExistDependency_4008(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            block5: {
                block4: {
                    try {
                        if (!(source instanceof Type) || !Util.isMetaclass((Type)((Type)source))) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                        return false;
                    }
                }
                if (!(source instanceof Extension)) break block5;
                return false;
            }
            return target == null || !(target instanceof Extension);
        }

        public boolean canExistDependency_4018(Package container, Dependency linkInstance, NamedElement source, NamedElement target) {
            block5: {
                block4: {
                    try {
                        if (!(source instanceof Type) || !Util.isMetaclass((Type)((Type)source))) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                        return false;
                    }
                }
                if (!(source instanceof Extension)) break block5;
                return false;
            }
            return target == null || !(target instanceof Extension);
        }

        public boolean canExistElementImport_1064(Namespace container, ElementImport linkInstance, Namespace source, PackageableElement target) {
            block5: {
                block4: {
                    try {
                        if (!(source instanceof Type) || !Util.isMetaclass((Type)((Type)source))) break block4;
                        return false;
                    }
                    catch (Exception e) {
                        UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                        return false;
                    }
                }
                if (!(source instanceof Extension)) break block5;
                return false;
            }
            return target == null || !(target instanceof Extension);
        }

        public boolean canExistPackageImport_1065(Namespace container, PackageImport linkInstance, Namespace source, Package target) {
            block3: {
                try {
                    if (!(source instanceof Type) || !Util.isMetaclass((Type)((Type)source))) break block3;
                    return false;
                }
                catch (Exception e) {
                    UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    return false;
                }
            }
            return !(source instanceof Extension);
        }

        public boolean canExistCommentAnnotatedElement_1022(Comment source, Element target) {
            try {
                return !(target instanceof Type) || !Util.isMetaclass((Type)((Type)target));
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }

        public boolean canExistConstraintConstrainedElement_4014(Constraint source, Element target) {
            try {
                return !(target instanceof Type) || !Util.isMetaclass((Type)((Type)target));
            }
            catch (Exception e) {
                UMLDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                return false;
            }
        }

        public boolean canExistConstraintContext_8500(Constraint source, Namespace target) {
            return true;
        }
    }
}

