/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AnnotatedLinkEndpointEditPolicy;

public abstract class AnnotatedLinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public AnnotatedLinkEditPart(View view) {
        super(view);
    }

    protected Connection createConnectionFigure() {
        return new AnnotatedLinkDescriptor();
    }

    public AnnotatedLinkDescriptor getPrimaryShape() {
        return (AnnotatedLinkDescriptor)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart ep = super.getTargetEditPart(request);
        if (ep != null && ep instanceof ConnectionEditPart && request instanceof ReconnectRequest) {
            ReconnectRequest rRequest = (ReconnectRequest)request;
            if (rRequest.isMovingStartAnchor() ? rRequest.getConnectionEditPart().getSource() == ep : rRequest.getConnectionEditPart().getTarget() == ep) {
                return ep;
            }
            if (this.isCyclicConnectionRequest((ConnectionEditPart)ep, rRequest.getConnectionEditPart(), false, rRequest.isMovingStartAnchor())) {
                return null;
            }
        }
        return ep;
    }

    private boolean isCyclicConnectionRequest(ConnectionEditPart targetCEP, ConnectionEditPart sourceCEP, boolean checkSourceAndTargetEditParts, boolean doNotCheckSourceEditPart) {
        if (targetCEP == null || sourceCEP == null) {
            return false;
        }
        if (sourceCEP == targetCEP) {
            return true;
        }
        HashSet set = new HashSet();
        this.getSourceAndTargetConnections(set, sourceCEP);
        if (set.contains(targetCEP.getFigure())) {
            return true;
        }
        EditPart sourceEP = sourceCEP.getSource();
        EditPart targetEP = sourceCEP.getTarget();
        if (sourceEP == targetCEP || targetEP == targetCEP) {
            return true;
        }
        if ((checkSourceAndTargetEditParts || !doNotCheckSourceEditPart) && sourceEP instanceof ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (ConnectionEditPart)sourceEP, true, doNotCheckSourceEditPart)) {
            return true;
        }
        return (checkSourceAndTargetEditParts || doNotCheckSourceEditPart) && targetEP instanceof ConnectionEditPart && this.isCyclicConnectionRequest(targetCEP, (ConnectionEditPart)targetEP, true, doNotCheckSourceEditPart);
    }

    private void getSourceAndTargetConnections(HashSet set, ConnectionEditPart connectionEditPart) {
        if (connectionEditPart == null || set == null) {
            return;
        }
        for (ConnectionEditPart next : connectionEditPart.getSourceConnections()) {
            Connection sourceConnection = (Connection)next.getFigure();
            set.add(sourceConnection);
            this.getSourceAndTargetConnections(set, next);
        }
        for (ConnectionEditPart next : connectionEditPart.getTargetConnections()) {
            Connection targetConnection = (Connection)next.getFigure();
            set.add(targetConnection);
            this.getSourceAndTargetConnections(set, next);
        }
        if (connectionEditPart instanceof AbstractMessageEditPart) {
            List children = ((AbstractMessageEditPart)connectionEditPart).getChildren();
            for (Object object : children) {
                if (!(object instanceof MessageEndEditPart)) continue;
                for (ConnectionEditPart next : ((MessageEndEditPart)((Object)object)).getSourceConnections()) {
                    Connection sourceConnection = (Connection)next.getFigure();
                    set.add(sourceConnection);
                    this.getSourceAndTargetConnections(set, next);
                }
                for (ConnectionEditPart next : ((MessageEndEditPart)((Object)object)).getTargetConnections()) {
                    Connection targetConnection = (Connection)next.getFigure();
                    set.add(targetConnection);
                    this.getSourceAndTargetConnections(set, next);
                }
            }
        }
    }

    protected void setLineWidth(int width) {
        this.getPrimaryShape().setLineWidth(width);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new AnnotatedLinkEndpointEditPolicy());
    }

    public class AnnotatedLinkDescriptor
    extends PolylineConnectionEx {
        public AnnotatedLinkDescriptor() {
            this.setLineStyle(2);
        }
    }
}

