/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ConsiderIgnoreFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomCombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.semantic.CustomConsiderIgnoreFragmentItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.uml2.uml.ConsiderIgnoreFragment;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomConsiderIgnoreFragmentEditPart
extends CustomCombinedFragmentEditPart {
    private NotificationHelper notifier = null;

    public CustomConsiderIgnoreFragmentEditPart(View view) {
        super(view);
    }

    protected NotificationHelper getNotifier() {
        if (this.notifier == null) {
            try {
                Field f = ConsiderIgnoreFragmentEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifier = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifier = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        CustomConsiderIgnoreFragmentEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifier;
    }

    @Override
    protected NodeFigure createNodePlate() {
        String prefElementId = "ConsiderIgnoreFragment";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        AnchorHelper.CombinedFragmentNodeFigure result = new AnchorHelper.CombinedFragmentNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomConsiderIgnoreFragmentItemSemanticEditPolicy());
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        NotificationHelper notifier = this.getNotifier();
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getConsiderIgnoreFragment_Message().equals(feature)) {
            Object newValue = notification.getNewValue();
            if (newValue == null || newValue instanceof Operation || newValue instanceof Reception || newValue instanceof Signal) {
                this.updateHeaderLabel();
                notifier.unlistenObject((Notifier)notification.getOldValue());
                notifier.listenObject((Notifier)notification.getNewValue());
            } else {
                ConsiderIgnoreFragment considerIgnoreFragment = (ConsiderIgnoreFragment)this.resolveSemanticElement();
                considerIgnoreFragment.getMessages().remove(newValue);
            }
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature)) {
            this.updateHeaderLabel();
        }
        super.handleNotificationEvent(notification);
    }

    @Override
    protected void updateHeaderLabel() {
        ConsiderIgnoreFragment considerIgnoreFragment = (ConsiderIgnoreFragment)this.resolveSemanticElement();
        StringBuilder operatorKind = new StringBuilder();
        operatorKind.append(considerIgnoreFragment.getInteractionOperator().getName());
        EList messages = considerIgnoreFragment.getMessages();
        if (messages != null && messages.size() > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < messages.size()) {
                String name = ((NamedElement)messages.get(i)).getName();
                if (name != null) {
                    sb.append(name).append(",");
                }
                ++i;
            }
            if (sb.length() > 0) {
                operatorKind.append(" {").append(sb.deleteCharAt(sb.length() - 1).toString()).append("}");
            }
        }
        this.getPrimaryShape().getHeaderLabel().setText(operatorKind.toString());
    }

    @Override
    protected boolean isAllowedInteractionOperator(String interactionOperatorLiteral) {
        return InteractionOperatorKind.CONSIDER_LITERAL.getLiteral().equals(interactionOperatorLiteral) || InteractionOperatorKind.IGNORE_LITERAL.getLiteral().equals(interactionOperatorLiteral);
    }

    public void activate() {
        super.activate();
        NotificationHelper notifier = this.getNotifier();
        ConsiderIgnoreFragment considerIgnoreFragment = (ConsiderIgnoreFragment)this.resolveSemanticElement();
        for (NamedElement message : considerIgnoreFragment.getMessages()) {
            notifier.listenObject((Notifier)message);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
    }

    public void removeNotify() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.removeNotify();
    }

    @Override
    public String getTitlePreferenceKey() {
        return "ELEMENT_PapyrusUMLSequenceDiagram_ConsiderIgnoreFragment_CombinedFragmentCompartment.compartment_name.visibility";
    }
}

