/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentCombinedFragmentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CombinedFragmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AbstractHeadImpactLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StereotypeInteractionFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.OperandBoundsComputeHelper;

public class CombinedFragmentHeadImpactLayoutEditPolicy
extends AbstractHeadImpactLayoutEditPolicy {
    @Override
    protected int getHeadHeight() {
        IFigure primaryShape = this.getPrimaryShape();
        if (primaryShape instanceof StereotypeInteractionFigure) {
            IFigure headContainer = ((StereotypeInteractionFigure)primaryShape).getHeaderLabel().getParent();
            Rectangle boundsRect = this.getBoundsRect();
            return headContainer.getPreferredSize((int)boundsRect.width, (int)-1).height;
        }
        return 0;
    }

    @Override
    protected void doImpactLayout(int resizeDelta) {
        Object child;
        CompoundCommand commands = new CompoundCommand();
        CombinedFragmentEditPart host = (CombinedFragmentEditPart)this.getHost();
        CombinedFragmentCombinedFragmentCompartmentEditPart compartment = (CombinedFragmentCombinedFragmentCompartmentEditPart)host.getPrimaryChildEditPart();
        List children = compartment.getChildren();
        if (!children.isEmpty() && (child = children.get(0)) instanceof InteractionOperandEditPart) {
            InteractionOperandEditPart operand = (InteractionOperandEditPart)((Object)child);
            Node shape = (Node)operand.getNotationView();
            Bounds bounds = (Bounds)shape.getLayoutConstraint();
            Dimension size = new Dimension(bounds.getWidth(), bounds.getHeight()).expand(0, -resizeDelta);
            Rectangle newBounds = new Rectangle(new Point(bounds.getX(), bounds.getY() + resizeDelta), size);
            commands.appendIfCanExecute((Command)new GMFtoEMFCommandWrapper((ICommand)new SetBoundsCommand(this.getEditingDomain(), "", (IAdaptable)operand, newBounds)));
            org.eclipse.gef.commands.Command cmd = OperandBoundsComputeHelper.getShiftEnclosedFragmentsCommand(operand, newBounds, resizeDelta);
            if (cmd != null) {
                commands.appendIfCanExecute((Command)new GEFtoEMFCommandWrapper(cmd));
            }
        }
        if (!commands.isEmpty() && commands.canExecute()) {
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), (Command)commands, true);
        }
        for (Object object : children) {
            EditPart part = (EditPart)object;
            EditPart current = part.getParent();
            while (current != null) {
                ExposeHelper helper = (ExposeHelper)current.getAdapter(ExposeHelper.class);
                if (helper != null) {
                    helper.exposeDescendant(part);
                }
                current = current.getParent();
            }
        }
    }
}

