/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.handlers;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.menu.actions.SizeAction;
import org.eclipse.papyrus.uml.diagram.menu.actions.handlers.SizeHandler;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

public class CustomSizeHandler
extends SizeHandler {
    protected Command getCommand() {
        return new CustomSizeAction(this.parameter, this.getSelectedElements()).getCommand();
    }

    protected static Rectangle getLifelineConstraint(List<IGraphicalEditPart> selectedElements) {
        Rectangle constraint = new Rectangle();
        int i = 0;
        while (i < selectedElements.size()) {
            LifelineEditPart lifelineEditPart = (LifelineEditPart)selectedElements.get(i);
            Rectangle rect = SequenceUtil.getAbsoluteBounds((IGraphicalEditPart)lifelineEditPart);
            constraint.union(rect);
            ++i;
        }
        return constraint;
    }

    protected boolean isLifelines(List<IGraphicalEditPart> selectedElements) {
        if (selectedElements.isEmpty()) {
            return true;
        }
        boolean isLifelines = true;
        int i = 0;
        while (i < selectedElements.size()) {
            isLifelines &= selectedElements.get(i) instanceof LifelineEditPart;
            ++i;
        }
        return isLifelines;
    }

    private static Dimension correctDelta(IGraphicalEditPart toResize, Dimension delta, Rectangle constraint) {
        Rectangle previousRect = SequenceUtil.getAbsoluteBounds(toResize);
        return new Dimension(delta.width, constraint.bottom() - previousRect.bottom());
    }

    public class CustomSizeAction
    extends SizeAction {
        public CustomSizeAction(String parameter, List<IGraphicalEditPart> selectedElements) {
            super(parameter, selectedElements);
        }

        protected Command getBothCommand() {
            if (CustomSizeHandler.this.isLifelines(this.selectedElements)) {
                return new LifeLinedSameHeightAction(this.selectedElements).getCommand();
            }
            return super.getBothCommand();
        }

        protected Command getHeightCommand() {
            if (CustomSizeHandler.this.isLifelines(this.selectedElements)) {
                return new LifeLinedSameHeightAction(this.selectedElements).getCommand();
            }
            return super.getHeightCommand();
        }

        protected class LifeLinedSameBothSizeAction
        extends SizeAction.SameBothSizeAction {
            private final Rectangle lifelinesContext;

            public LifeLinedSameBothSizeAction(List<IGraphicalEditPart> selectedElements) {
                super(selectedElements);
                this.lifelinesContext = CustomSizeHandler.getLifelineConstraint(selectedElements);
            }

            protected Dimension calculateDelta(IGraphicalEditPart toResize, Dimension previousSize) {
                Dimension delta = super.calculateDelta(toResize, previousSize);
                return CustomSizeHandler.correctDelta(toResize, delta, this.lifelinesContext);
            }
        }

        protected class LifeLinedSameHeightAction
        extends SizeAction.SameHeightSizeAction {
            private final Rectangle lifelinesContext;

            public LifeLinedSameHeightAction(List<IGraphicalEditPart> selectedElements) {
                super(selectedElements);
                this.lifelinesContext = CustomSizeHandler.getLifelineConstraint(selectedElements);
            }

            protected Dimension calculateDelta(IGraphicalEditPart toResize, Dimension newSize) {
                Dimension delta = super.calculateDelta(toResize, newSize);
                return CustomSizeHandler.correctDelta(toResize, delta, this.lifelinesContext);
            }
        }
    }
}

