/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Object[] getViewChildrenForPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup links = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        if (!links.isEmpty()) {
            result.add(links);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interaction_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interaction_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3004));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3001));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3002));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3008));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3009));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForLifelineEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Lifeline_3001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Lifeline_3001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionExecutionSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionExecutionSpecification_3006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionExecutionSpecification_3006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForBehaviorExecutionSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BehaviorExecutionSpecification_3003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BehaviorExecutionSpecification_3003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForStateInvariantEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StateInvariant_3017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StateInvariant_3017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCombinedFragment2EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_3018_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_3018_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_3019_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_3019_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationObservationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationObservation_3024_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationObservation_3024_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeObservationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeObservation_3020_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeObservation_3020_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3021_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3021_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionUseEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionUse_3002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionUse_3002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCombinedFragmentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_3004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_3004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3005));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionOperandEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionOperand_3005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionOperand_3005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForContinuationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Continuation_3016_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Continuation_3016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintInMessageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3023_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3023_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConsiderIgnoreFragmentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConsiderIgnoreFragment_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConsiderIgnoreFragment_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage2EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage3EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4005_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4005_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage4EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4006_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4006_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage5EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4007_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4007_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage6EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4008_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4008_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage7EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4009_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4009_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_4009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentAnnotatedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4010_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4010_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDestructionOccurrenceSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestructionOccurrenceSpecification_3022_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestructionOccurrenceSpecification_3022_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4007));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintConstrainedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4011_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4011_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3002));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3003));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "PapyrusUMLSequenceDiagram"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getViewChildrenForPackageEditPart(view, parentElement);
            }
            case 2001: {
                return this.getViewChildrenForInteractionEditPart(view, parentElement);
            }
            case 3001: {
                return this.getViewChildrenForLifelineEditPart(view, parentElement);
            }
            case 3002: {
                return this.getViewChildrenForInteractionUseEditPart(view, parentElement);
            }
            case 3003: {
                return this.getViewChildrenForBehaviorExecutionSpecificationEditPart(view, parentElement);
            }
            case 3004: {
                return this.getViewChildrenForCombinedFragmentEditPart(view, parentElement);
            }
            case 3005: {
                return this.getViewChildrenForInteractionOperandEditPart(view, parentElement);
            }
            case 3006: {
                return this.getViewChildrenForActionExecutionSpecificationEditPart(view, parentElement);
            }
            case 3007: {
                return this.getViewChildrenForConsiderIgnoreFragmentEditPart(view, parentElement);
            }
            case 3008: {
                return this.getViewChildrenForConstraintEditPart(view, parentElement);
            }
            case 3009: {
                return this.getViewChildrenForCommentEditPart(view, parentElement);
            }
            case 3016: {
                return this.getViewChildrenForContinuationEditPart(view, parentElement);
            }
            case 3017: {
                return this.getViewChildrenForStateInvariantEditPart(view, parentElement);
            }
            case 3018: {
                return this.getViewChildrenForCombinedFragment2EditPart(view, parentElement);
            }
            case 3019: {
                return this.getViewChildrenForTimeConstraintEditPart(view, parentElement);
            }
            case 3020: {
                return this.getViewChildrenForTimeObservationEditPart(view, parentElement);
            }
            case 3021: {
                return this.getViewChildrenForDurationConstraintEditPart(view, parentElement);
            }
            case 3022: {
                return this.getViewChildrenForDestructionOccurrenceSpecificationEditPart(view, parentElement);
            }
            case 3023: {
                return this.getViewChildrenForDurationConstraintInMessageEditPart(view, parentElement);
            }
            case 3024: {
                return this.getViewChildrenForDurationObservationEditPart(view, parentElement);
            }
            case 4003: {
                return this.getViewChildrenForMessageEditPart(view, parentElement);
            }
            case 4004: {
                return this.getViewChildrenForMessage2EditPart(view, parentElement);
            }
            case 4005: {
                return this.getViewChildrenForMessage3EditPart(view, parentElement);
            }
            case 4006: {
                return this.getViewChildrenForMessage4EditPart(view, parentElement);
            }
            case 4007: {
                return this.getViewChildrenForMessage5EditPart(view, parentElement);
            }
            case 4008: {
                return this.getViewChildrenForMessage6EditPart(view, parentElement);
            }
            case 4009: {
                return this.getViewChildrenForMessage7EditPart(view, parentElement);
            }
            case 4010: {
                return this.getViewChildrenForCommentAnnotatedElementEditPart(view, parentElement);
            }
            case 4011: {
                return this.getViewChildrenForConstraintConstrainedElementEditPart(view, parentElement);
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new UMLNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

