/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.emf.databinding.AnnotationObservableValue;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.modelelement.AnnotationModelElement;
import org.eclipse.papyrus.views.properties.modelelement.AnnotationModelElementFactory;

public class InteractionOperandModelElementFactory
extends AnnotationModelElementFactory {
    public static final String GUARD_VISIBILITY_KEY = "guard.visibility";

    protected AnnotationModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        View source = NotationHelper.findView((Object)sourceElement);
        if (source == null) {
            Activator.log.warn("Unable to resolve the selected element to an EObject");
            return null;
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)source);
        return new AnnotationModelElement((EModelElement)source, domain, GUARD_VISIBILITY_KEY){

            public IObservable doGetObservable(String propertyPath) {
                return new AnnotationObservableValue(this.source, this.domain, InteractionOperandModelElementFactory.GUARD_VISIBILITY_KEY, InteractionOperandModelElementFactory.GUARD_VISIBILITY_KEY){

                    protected Command getCommand(final Object value) {
                        return new CreateEAnnotationCommand((TransactionalEditingDomain)this.domain, this.source, InteractionOperandModelElementFactory.GUARD_VISIBILITY_KEY){

                            protected void doExecute() {
                                EAnnotation annotation = this.createEAnnotation();
                                this.replaceEannotation(annotation, this.getObject());
                                this.replaceEntry(annotation, InteractionOperandModelElementFactory.GUARD_VISIBILITY_KEY, value == null ? "" : value.toString());
                            }
                        };
                    }

                    protected Object doGetValue() {
                        Object value = super.doGetValue();
                        if (value == null) {
                            return UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getString("PapyrusUMLSequenceDiagram_InteractionOperand.guard.visibility");
                        }
                        return value;
                    }
                };
            }
        };
    }

    public static final boolean isGuardVisibilityChanged(Notification msg) {
        if (msg == null || !(msg.getNewValue() instanceof EAnnotation)) {
            return false;
        }
        EAnnotation anno = (EAnnotation)msg.getNewValue();
        return GUARD_VISIBILITY_KEY.equals(anno.getSource());
    }

    public static final boolean isGuardVisible(View view) {
        EAnnotation anno;
        if (view != null && (anno = view.getEAnnotation(GUARD_VISIBILITY_KEY)) != null) {
            return "true".equalsIgnoreCase((String)anno.getDetails().get((Object)GUARD_VISIBILITY_KEY));
        }
        return UMLDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("PapyrusUMLSequenceDiagram_InteractionOperand.guard.visibility");
    }
}

