/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomRegionResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomRegionResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.RegionEditPart;

public class CustomStateCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (request == null || child == null || constraint == null) {
            throw new IllegalArgumentException();
        }
        if (child instanceof RegionEditPart) {
            View region = (View)child.getModel();
            int dx = request.getSizeDelta().width;
            int dy = request.getSizeDelta().height;
            if (dx == 0 && dy == 0) {
                return UnexecutableCommand.INSTANCE;
            }
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
            SemanticAdapter adaptableForRegion = new SemanticAdapter(null, (Object)region);
            CustomRegionResizeCommand resizeRegion = new CustomRegionResizeCommand((IAdaptable)adaptableForRegion, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint(), editingDomain, DiagramUIMessages.CreateCommand_Label, request, (Rectangle)constraint);
            cc.add((IUndoableOperation)resizeRegion);
            return new ICommandProxy(cc.reduce());
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof RegionEditPart) {
            CustomRegionResizableEditPolicy policy = new CustomRegionResizableEditPolicy();
            View region = (View)child.getModel();
            String zone = Zone.getZone(region);
            int dirs = Zone.getAllowedResizeDirections(zone);
            policy.setResizeDirections(dirs);
            return policy;
        }
        return super.createChildEditPolicy(child);
    }
}

