/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;

public class CustomInteractionCreationEditPolicy
extends PapyrusCreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        ICommandProxy superCommand = (ICommandProxy)super.getCreateCommand(request);
        List viewDescriptors = request.getViewDescriptors();
        if (request instanceof CreateViewAndElementRequest && viewDescriptors.size() == 1) {
            String semanticHint = ((CreateViewRequest.ViewDescriptor)viewDescriptors.get(0)).getSemanticHint();
            if (Integer.toString(69).equals(semanticHint)) {
                return this.getCreateGateCommand(request, superCommand);
            }
        }
        return superCommand;
    }

    private Command getCreateGateCommand(final CreateViewRequest request, ICommandProxy superCommand) {
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomInteractionCreationEditPolicy_CreateGate);
        compoundCommand.add((Command)superCommand);
        final ICommand iCommand = superCommand.getICommand();
        TransactionalEditingDomain editingDomain = ((AbstractEMFOperation)iCommand).getEditingDomain();
        compoundCommand.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, Messages.CustomInteractionCreationEditPolicy_PositionGate, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult commandResult = iCommand.getCommandResult();
                Object returnValue = commandResult.getReturnValue();
                CreateViewAndElementRequest.ViewAndElementDescriptor descriptor = (CreateViewAndElementRequest.ViewAndElementDescriptor)returnValue;
                Node node = (Node)descriptor.getAdapter(Node.class);
                Node interactionView = (Node)ViewUtils.findSuperViewWithId((View)node, 2);
                Location interactionLocation = (Location)interactionView.getLayoutConstraint();
                IFigure hostFigure = ((GraphicalEditPart)CustomInteractionCreationEditPolicy.this.getHost()).getFigure();
                Point point = new Point(request.getLocation());
                Point origin = FigureUtils.getLayeredPaneOrigin((IFigure)hostFigure);
                point.translate(origin);
                Point location = FigureUtils.scaleByZoom((Point)point, (IFigure)hostFigure);
                Location loc = NotationFactory.eINSTANCE.createLocation();
                loc.setX(location.x - interactionLocation.getX());
                loc.setY(location.y - interactionLocation.getY());
                node.setLayoutConstraint((LayoutConstraint)loc);
                return CommandResult.newOKCommandResult();
            }
        }));
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)this.getHost()));
        return compoundCommand;
    }
}

