/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.ValidateInteractionCommand;
import org.eclipse.papyrus.uml.diagram.timing.custom.helper.TimingDiagramLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.DropUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.InteractionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Utils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public class TimingDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    private static final Integer[] SPECIFIC_DROP_ELEMENT_IDS = new Integer[]{2, 19, 20, 3, 4, 41, 44, 47, 53, 50, 16, 15, 17, 18, 67, 69};

    public TimingDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)TimingDiagramLinkMappingHelper.getInstance());
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        switch (nodeVISUALID) {
            case 2: {
                return new ICommandProxy(this.dropMainElement(dropRequest, semanticElement, nodeVISUALID));
            }
            case 19: 
            case 20: {
                return new ICommandProxy(this.dropLifeline(dropRequest, semanticElement, nodeVISUALID));
            }
        }
        if (this.getHost().getModel() instanceof View) {
            View hostView = (View)this.getHost().getModel();
            if (MessageUtils.isMessage(linkVISUALID) && semanticElement instanceof Message) {
                return new ICommandProxy(DropUtils.getDropMessageCommand((Message)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 16) {
                return new ICommandProxy(DropUtils.getDropTimeObservationCommand((TimeObservation)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 15) {
                return new ICommandProxy(DropUtils.getDropTimeConstraintCommand((TimeConstraint)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 17) {
                return new ICommandProxy(DropUtils.getDropDurationObservationCommand((DurationObservation)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 18) {
                return new ICommandProxy(DropUtils.getDropDurationConstraintCommand((DurationConstraint)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 67) {
                return new ICommandProxy(DropUtils.getDropGeneralOrderingCommand((GeneralOrdering)semanticElement, hostView, this.getViewer()));
            }
            if (nodeVISUALID == 69) {
                return new ICommandProxy(DropUtils.getDropGateCommand((Gate)semanticElement, hostView, this.getViewer()));
            }
        }
        return super.getSpecificDropCommand(dropRequest, semanticElement, nodeVISUALID, linkVISUALID);
    }

    private ICommand dropLifeline(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        if (!(semanticElement instanceof Lifeline)) {
            throw new IllegalArgumentException();
        }
        Lifeline lifeline = (Lifeline)semanticElement;
        CompositeCommand cc = new CompositeCommand(Messages.TimingDiagramDragDropEditPolicy_DropLifeline);
        ICommand dropMainElementCommand = this.dropMainElement(dropRequest, semanticElement, nodeVISUALID);
        cc.add((IUndoableOperation)dropMainElementCommand);
        LifelineUtils.LifelineType lifelineType = LifelineUtils.getLifelineType(lifeline);
        if (lifelineType == LifelineUtils.LifelineType.full) {
            cc.add((IUndoableOperation)TimingDiagramDragDropEditPolicy.dropStateDefinitions(lifeline, dropMainElementCommand.getCommandResult()));
        }
        cc.add((IUndoableOperation)TimingDiagramDragDropEditPolicy.dropLifelineFragments(lifeline, dropMainElementCommand.getCommandResult(), lifelineType));
        return cc;
    }

    private static ICommand dropStateDefinitions(final Lifeline lifeline, CommandResult lifelineCreateViewCommandResult) {
        if (lifelineCreateViewCommandResult == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)lifeline);
        final Object returnValue = lifelineCreateViewCommandResult.getReturnValue();
        return new AbstractTransactionalCommand(editingDomain, Messages.TimingDiagramDragDropEditPolicy_DropStateDefinitions, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (returnValue instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)returnValue;
                    View lifelineView = (View)adaptable.getAdapter(View.class);
                    if (lifelineView == null) {
                        return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                    }
                    View stateDefinitionCompartmentView = ViewUtils.findStateDefinitionCompartmentView(lifelineView);
                    List<String> stateDefinitionIds = StateDefinitionUtils.getStateDefinitionIds(lifeline);
                    for (String stateDefinitionId : stateDefinitionIds) {
                        String stateDefinitionName = StateDefinitionUtils.getStateDefinitionName(stateDefinitionId, lifeline);
                        UMLViewProvider umlViewProvider = new UMLViewProvider();
                        Node stateDefinitionView = umlViewProvider.createNode_9(null, stateDefinitionCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        StateDefinitionUtils.setStateDefinitionViewID((View)stateDefinitionView, stateDefinitionId);
                        StateDefinitionUtils.setStateDefinitionName((View)stateDefinitionView, stateDefinitionName);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static ICommand dropLifelineFragments(final Lifeline lifeline, CommandResult lifelineCreateViewCommandResult, final LifelineUtils.LifelineType lifelineType) {
        if (lifelineCreateViewCommandResult == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)lifeline);
        final Object returnValue = lifelineCreateViewCommandResult.getReturnValue();
        return new AbstractTransactionalCommand(editingDomain, Messages.TimingDiagramDragDropEditPolicy_DropLifelineFragments, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (returnValue instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)returnValue;
                    View lifelineView = (View)adaptable.getAdapter(View.class);
                    if (lifelineView == null) {
                        return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                    }
                    View compartmentView = lifelineType == LifelineUtils.LifelineType.full ? ViewUtils.findFullLifelineCompartmentView(lifelineView) : ViewUtils.findCompactTimelineCompartmentView(lifelineView);
                    EList fragments = lifeline.getCoveredBys();
                    UMLViewProvider umlViewProvider = new UMLViewProvider();
                    int x = lifelineType == LifelineUtils.LifelineType.full ? 20 : 100;
                    boolean firstStateInvariant = true;
                    String previousStateInvariantName = "";
                    for (InteractionFragment fragment : fragments) {
                        MessageOccurrenceSpecification occurrenceSpecification;
                        Location loc;
                        Node occurrenceSpecificationView;
                        if (fragment instanceof StateInvariant) {
                            if (!firstStateInvariant && lifelineType == LifelineUtils.LifelineType.full) {
                                umlViewProvider.createNode_39(null, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                            }
                            StateInvariant stateInvariant = (StateInvariant)fragment;
                            String stateInvariantName = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
                            x = lifelineType == LifelineUtils.LifelineType.full ? (Utils.safeEquals(stateInvariantName, previousStateInvariantName) ? (x += 10) : (x += 25)) : (x += 60);
                            if (lifelineType == LifelineUtils.LifelineType.full) {
                                umlViewProvider.createStateInvariant_11((EObject)stateInvariant, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                            } else if (lifelineType == LifelineUtils.LifelineType.compact) {
                                umlViewProvider.createStateInvariant_28((EObject)stateInvariant, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                            }
                            firstStateInvariant = false;
                            previousStateInvariantName = stateInvariantName;
                            continue;
                        }
                        if (fragment instanceof DestructionOccurrenceSpecification) {
                            DestructionOccurrenceSpecification destructionOccurrenceSpecification = (DestructionOccurrenceSpecification)fragment;
                            occurrenceSpecificationView = umlViewProvider.createDestructionOccurrenceSpecification_27((EObject)destructionOccurrenceSpecification, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                            loc = NotationFactory.eINSTANCE.createLocation();
                            loc.setX(x);
                            loc.setY(0);
                            occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                            x += 10;
                            continue;
                        }
                        if (fragment instanceof MessageOccurrenceSpecification) {
                            occurrenceSpecification = (MessageOccurrenceSpecification)fragment;
                            occurrenceSpecificationView = umlViewProvider.createMessageOccurrenceSpecification_13((EObject)occurrenceSpecification, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                            loc = NotationFactory.eINSTANCE.createLocation();
                            loc.setX(x);
                            loc.setY(0);
                            occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                            x += 10;
                            continue;
                        }
                        if (!(fragment instanceof OccurrenceSpecification)) continue;
                        occurrenceSpecification = (OccurrenceSpecification)fragment;
                        occurrenceSpecificationView = umlViewProvider.createOccurrenceSpecification_12((EObject)occurrenceSpecification, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        loc = NotationFactory.eINSTANCE.createLocation();
                        loc.setX(x);
                        loc.setY(0);
                        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                        x += 10;
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand dropMainElement(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID) {
        if (this.canBeDropped(semanticElement)) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            return this.getDefaultDropNodeCommand(this.getHost(), semanticHint, dropRequest.getLocation(), (EObject)semanticElement, dropRequest);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private boolean canBeDropped(Element semanticElement) {
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        EObject graphicalParentObject = graphicalParentEditPart.resolveSemanticElement();
        return graphicalParentObject instanceof Package && semanticElement instanceof Interaction || graphicalParentObject instanceof Interaction && semanticElement instanceof Lifeline;
    }

    protected Set<Integer> getDroppableElementVisualId() {
        return new HashSet<Integer>(Arrays.asList(SPECIFIC_DROP_ELEMENT_IDS));
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement instanceof Gate && (String.valueOf(2).equals(containerView.getType()) || String.valueOf(5).equals(containerView.getType()))) {
            return 69;
        }
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        CompoundCommand cc = new CompoundCommand(Messages.TimingDiagramDragDropEditPolicy_Drop);
        ArrayList<Interaction> updatedInteractionsCache = new ArrayList<Interaction>();
        List droppedObjects = dropRequest.getObjects();
        for (Object droppedObject : droppedObjects) {
            EObject droppedEObject;
            Interaction interaction;
            if (!(droppedObject instanceof EObject) || (interaction = InteractionUtils.getContainingInteraction(droppedEObject = (EObject)droppedObject)) == null || updatedInteractionsCache.contains(interaction)) continue;
            ValidateInteractionCommand validateCommand = new ValidateInteractionCommand(this.getEditingDomain(), interaction, true);
            cc.add((Command)new ICommandProxy((ICommand)validateCommand));
            updatedInteractionsCache.add(interaction);
        }
        cc.add(super.getDropObjectsCommand(dropRequest));
        return cc;
    }
}

