/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.part;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.update.DiagramUpdater;
import org.eclipse.papyrus.uml.diagram.timing.custom.parts.PropertyDiagramUpdater;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLElementTypes;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLDiagramUpdater
implements DiagramUpdater {
    public static final UMLDiagramUpdater INSTANCE = new UMLDiagramUpdater();

    protected UMLDiagramUpdater() {
    }

    public List<UMLNodeDescriptor> getSemanticChildren(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1: {
                return this.getPackage_1SemanticChildren(view);
            }
            case 2: {
                return this.getInteraction_2SemanticChildren(view);
            }
            case 5: {
                return this.getInteractionInteractionCompartment_5SemanticChildren(view);
            }
            case 7: {
                return this.getLifelineFullLifelineStateDefinitionCompartment_7SemanticChildren(view);
            }
            case 8: {
                return this.getLifelineFullLifelineTimelineCompartment_8SemanticChildren(view);
            }
            case 23: {
                return this.getLifelineCompactLifelineCompartment_23SemanticChildren(view);
            }
            case 29: {
                return this.getInteractionTimeRulerCompartment_29SemanticChildren(view);
            }
            case 82: {
                return this.getLifelineFullLifelineTimeRuler_82SemanticChildren(view);
            }
            case 83: {
                return this.getLifelineCompactLifelineTimeRuler_83SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public List<UMLNodeDescriptor> getPackage_1SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (PackageableElement childElement : modelElement.getPackagedElements()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getInteraction_2SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Interaction modelElement = (Interaction)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Gate childElement : modelElement.getFormalGates()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 69) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getInteractionInteractionCompartment_5SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Interaction modelElement = (Interaction)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Lifeline childElement : modelElement.getLifelines()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 19) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 20) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getLifelineFullLifelineStateDefinitionCompartment_7SemanticChildren(View view) {
        return Collections.emptyList();
    }

    public List<UMLNodeDescriptor> getLifelineFullLifelineTimelineCompartment_8SemanticChildren(View view) {
        PropertyDiagramUpdater customUpdater = new PropertyDiagramUpdater();
        return customUpdater.getSemanticChildren(view);
    }

    public List<UMLNodeDescriptor> getLifelineCompactLifelineCompartment_23SemanticChildren(View view) {
        PropertyDiagramUpdater customUpdater = new PropertyDiagramUpdater();
        return customUpdater.getSemanticChildren(view);
    }

    public List<UMLNodeDescriptor> getInteractionTimeRulerCompartment_29SemanticChildren(View view) {
        return Collections.emptyList();
    }

    public List<UMLNodeDescriptor> getLifelineFullLifelineTimeRuler_82SemanticChildren(View view) {
        return Collections.emptyList();
    }

    public List<UMLNodeDescriptor> getLifelineCompactLifelineTimeRuler_83SemanticChildren(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getContainedLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1: {
                return this.getPackage_1ContainedLinks(view);
            }
            case 2: {
                return this.getInteraction_2ContainedLinks(view);
            }
            case 19: {
                return this.getLifeline_19ContainedLinks(view);
            }
            case 20: {
                return this.getLifeline_20ContainedLinks(view);
            }
            case 11: {
                return this.getStateInvariant_11ContainedLinks(view);
            }
            case 28: {
                return this.getStateInvariant_28ContainedLinks(view);
            }
            case 12: {
                return this.getOccurrenceSpecification_12ContainedLinks(view);
            }
            case 13: {
                return this.getMessageOccurrenceSpecification_13ContainedLinks(view);
            }
            case 15: {
                return this.getTimeConstraint_15ContainedLinks(view);
            }
            case 16: {
                return this.getTimeObservation_16ContainedLinks(view);
            }
            case 18: {
                return this.getDurationConstraint_18ContainedLinks(view);
            }
            case 17: {
                return this.getDurationObservation_17ContainedLinks(view);
            }
            case 67: {
                return this.getGeneralOrdering_67ContainedLinks(view);
            }
            case 27: {
                return this.getDestructionOccurrenceSpecification_27ContainedLinks(view);
            }
            case 40: {
                return this.getLifeline_40ContainedLinks(view);
            }
            case 69: {
                return this.getGate_69ContainedLinks(view);
            }
            case 3: {
                return this.getMessage_3ContainedLinks(view);
            }
            case 4: {
                return this.getMessage_4ContainedLinks(view);
            }
            case 41: {
                return this.getMessage_41ContainedLinks(view);
            }
            case 44: {
                return this.getMessage_44ContainedLinks(view);
            }
            case 47: {
                return this.getMessage_47ContainedLinks(view);
            }
            case 50: {
                return this.getMessage_50ContainedLinks(view);
            }
            case 53: {
                return this.getMessage_53ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getIncomingLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 2: {
                return this.getInteraction_2IncomingLinks(view);
            }
            case 19: {
                return this.getLifeline_19IncomingLinks(view);
            }
            case 20: {
                return this.getLifeline_20IncomingLinks(view);
            }
            case 11: {
                return this.getStateInvariant_11IncomingLinks(view);
            }
            case 28: {
                return this.getStateInvariant_28IncomingLinks(view);
            }
            case 12: {
                return this.getOccurrenceSpecification_12IncomingLinks(view);
            }
            case 13: {
                return this.getMessageOccurrenceSpecification_13IncomingLinks(view);
            }
            case 15: {
                return this.getTimeConstraint_15IncomingLinks(view);
            }
            case 16: {
                return this.getTimeObservation_16IncomingLinks(view);
            }
            case 18: {
                return this.getDurationConstraint_18IncomingLinks(view);
            }
            case 17: {
                return this.getDurationObservation_17IncomingLinks(view);
            }
            case 67: {
                return this.getGeneralOrdering_67IncomingLinks(view);
            }
            case 27: {
                return this.getDestructionOccurrenceSpecification_27IncomingLinks(view);
            }
            case 40: {
                return this.getLifeline_40IncomingLinks(view);
            }
            case 69: {
                return this.getGate_69IncomingLinks(view);
            }
            case 3: {
                return this.getMessage_3IncomingLinks(view);
            }
            case 4: {
                return this.getMessage_4IncomingLinks(view);
            }
            case 41: {
                return this.getMessage_41IncomingLinks(view);
            }
            case 44: {
                return this.getMessage_44IncomingLinks(view);
            }
            case 47: {
                return this.getMessage_47IncomingLinks(view);
            }
            case 50: {
                return this.getMessage_50IncomingLinks(view);
            }
            case 53: {
                return this.getMessage_53IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOutgoingLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 2: {
                return this.getInteraction_2OutgoingLinks(view);
            }
            case 19: {
                return this.getLifeline_19OutgoingLinks(view);
            }
            case 20: {
                return this.getLifeline_20OutgoingLinks(view);
            }
            case 11: {
                return this.getStateInvariant_11OutgoingLinks(view);
            }
            case 28: {
                return this.getStateInvariant_28OutgoingLinks(view);
            }
            case 12: {
                return this.getOccurrenceSpecification_12OutgoingLinks(view);
            }
            case 13: {
                return this.getMessageOccurrenceSpecification_13OutgoingLinks(view);
            }
            case 15: {
                return this.getTimeConstraint_15OutgoingLinks(view);
            }
            case 16: {
                return this.getTimeObservation_16OutgoingLinks(view);
            }
            case 18: {
                return this.getDurationConstraint_18OutgoingLinks(view);
            }
            case 17: {
                return this.getDurationObservation_17OutgoingLinks(view);
            }
            case 67: {
                return this.getGeneralOrdering_67OutgoingLinks(view);
            }
            case 27: {
                return this.getDestructionOccurrenceSpecification_27OutgoingLinks(view);
            }
            case 40: {
                return this.getLifeline_40OutgoingLinks(view);
            }
            case 69: {
                return this.getGate_69OutgoingLinks(view);
            }
            case 3: {
                return this.getMessage_3OutgoingLinks(view);
            }
            case 4: {
                return this.getMessage_4OutgoingLinks(view);
            }
            case 41: {
                return this.getMessage_41OutgoingLinks(view);
            }
            case 44: {
                return this.getMessage_44OutgoingLinks(view);
            }
            case 47: {
                return this.getMessage_47OutgoingLinks(view);
            }
            case 50: {
                return this.getMessage_50OutgoingLinks(view);
            }
            case 53: {
                return this.getMessage_53OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPackage_1ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getInteraction_2ContainedLinks(View view) {
        Interaction modelElement = (Interaction)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Message_3(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_4(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_41(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_44(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_47(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_50(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Message_53(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_19ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getLifeline_20ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getStateInvariant_11ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getStateInvariant_28ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOccurrenceSpecification_12ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessageOccurrenceSpecification_13ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getTimeConstraint_15ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getTimeObservation_16ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDurationConstraint_18ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDurationObservation_17ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getGeneralOrdering_67ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDestructionOccurrenceSpecification_27ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getLifeline_40ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getGate_69ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_3ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_4ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_41ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_44ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_47ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_50ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getMessage_53ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getInteraction_2IncomingLinks(View view) {
        Interaction modelElement = (Interaction)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_19IncomingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_20IncomingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getStateInvariant_11IncomingLinks(View view) {
        StateInvariant modelElement = (StateInvariant)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getStateInvariant_28IncomingLinks(View view) {
        StateInvariant modelElement = (StateInvariant)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getOccurrenceSpecification_12IncomingLinks(View view) {
        OccurrenceSpecification modelElement = (OccurrenceSpecification)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessageOccurrenceSpecification_13IncomingLinks(View view) {
        MessageOccurrenceSpecification modelElement = (MessageOccurrenceSpecification)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_3((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_4((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_41((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_44((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_47((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_53((MessageEnd)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getTimeConstraint_15IncomingLinks(View view) {
        TimeConstraint modelElement = (TimeConstraint)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getTimeObservation_16IncomingLinks(View view) {
        TimeObservation modelElement = (TimeObservation)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDurationConstraint_18IncomingLinks(View view) {
        DurationConstraint modelElement = (DurationConstraint)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDurationObservation_17IncomingLinks(View view) {
        DurationObservation modelElement = (DurationObservation)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getGeneralOrdering_67IncomingLinks(View view) {
        GeneralOrdering modelElement = (GeneralOrdering)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDestructionOccurrenceSpecification_27IncomingLinks(View view) {
        DestructionOccurrenceSpecification modelElement = (DestructionOccurrenceSpecification)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_3((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_4((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_41((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_44((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_47((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_53((MessageEnd)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_40IncomingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getGate_69IncomingLinks(View view) {
        Gate modelElement = (Gate)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_3((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_4((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_41((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_44((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_47((MessageEnd)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_53((MessageEnd)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_3IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_4IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_41IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_44IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_47IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_50IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_53IncomingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Message_50((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getInteraction_2OutgoingLinks(View view) {
        Interaction modelElement = (Interaction)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_19OutgoingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_20OutgoingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getStateInvariant_11OutgoingLinks(View view) {
        StateInvariant modelElement = (StateInvariant)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getStateInvariant_28OutgoingLinks(View view) {
        StateInvariant modelElement = (StateInvariant)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getOccurrenceSpecification_12OutgoingLinks(View view) {
        OccurrenceSpecification modelElement = (OccurrenceSpecification)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessageOccurrenceSpecification_13OutgoingLinks(View view) {
        MessageOccurrenceSpecification modelElement = (MessageOccurrenceSpecification)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_3((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_4((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_41((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_44((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_47((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_50((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getTimeConstraint_15OutgoingLinks(View view) {
        TimeConstraint modelElement = (TimeConstraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getTimeObservation_16OutgoingLinks(View view) {
        TimeObservation modelElement = (TimeObservation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDurationConstraint_18OutgoingLinks(View view) {
        DurationConstraint modelElement = (DurationConstraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDurationObservation_17OutgoingLinks(View view) {
        DurationObservation modelElement = (DurationObservation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getGeneralOrdering_67OutgoingLinks(View view) {
        GeneralOrdering modelElement = (GeneralOrdering)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDestructionOccurrenceSpecification_27OutgoingLinks(View view) {
        DestructionOccurrenceSpecification modelElement = (DestructionOccurrenceSpecification)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_3((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_4((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_41((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_44((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_47((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_50((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getLifeline_40OutgoingLinks(View view) {
        Lifeline modelElement = (Lifeline)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getGate_69OutgoingLinks(View view) {
        Gate modelElement = (Gate)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_3((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_4((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_41((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_44((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_47((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_50((MessageEnd)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_3OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_4OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_41OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_44OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_47OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_50OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getMessage_53OutgoingLinks(View view) {
        Message modelElement = (Message)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Message_53((Element)modelElement));
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_3(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 3 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_3, 3));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_4(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 4 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_4, 4));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_41(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 41 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_41, 41));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_44(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 44 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_44, 44));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_47(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 47 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_47, 47));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_50(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 50 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            Element dst = link.getOwner();
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_50, 50));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Message_53(Interaction container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 53 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            Element src = link.getOwner();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_53, 53));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_3(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 3 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_3, 3));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_4(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 4 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_4, 4));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_41(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 41 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_41, 41));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_44(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 44 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_44, 44));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_47(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 47 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_47, 47));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_50(Element target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getElement_Owner() || !(setting.getEObject() instanceof Message) || 50 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            MessageEnd src = link.getReceiveEvent();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_50, 50));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Message_53(MessageEnd target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Message link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getMessage_SendEvent() || !(setting.getEObject() instanceof Message) || 53 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)setting.getEObject()))) continue;
            Element src = link.getOwner();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Message_53, 53));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_3(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 3 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_3, 3));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_4(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 4 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_4, 4));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_41(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 41 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_41, 41));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_44(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 44 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_44, 44));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_47(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 47 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_47, 47));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_50(MessageEnd source) {
        Interaction container = null;
        MessageEnd element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 50 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            Element dst = link.getOwner();
            MessageEnd src = link.getReceiveEvent();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_50, 50));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Message_53(Element source) {
        Interaction container = null;
        Element element = source;
        while (element != null && container == null) {
            if (element instanceof Interaction) {
                container = (Interaction)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getMessages()) {
            Message link;
            if (!(linkObject instanceof Message) || 53 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Message)linkObject))) continue;
            MessageEnd dst = link.getSendEvent();
            Element src = link.getOwner();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Message_53, 53));
        }
        return result;
    }
}

