/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.usecase.custom.edit.parts;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.usecase.edit.parts.AssociationEditPart;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class CustomAssociationEditPart
extends AssociationEditPart {
    public CustomAssociationEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.addAssociationEndListeners();
    }

    public void deactivate() {
        this.removeAssociationEndListeners();
        super.deactivate();
    }

    protected void addAssociationEndListeners() {
        this.addListenerFilter("AssociationEndListenersSource", (NotificationListener)this, (EObject)this.getSourceProperty());
        this.addListenerFilter("AssociationEndListenersTarget", (NotificationListener)this, (EObject)this.getTargetProperty());
    }

    protected void removeAssociationEndListeners() {
        this.removeListenerFilter("AssociationEndListenersSource");
        this.removeListenerFilter("AssociationEndListenersTarget");
    }

    protected void refreshVisuals() {
        Property source = this.getSourceProperty();
        Property target = this.getTargetProperty();
        int sourceType = 0;
        int targetType = 0;
        if (source != null && source.isNavigable()) {
            ++sourceType;
        }
        if (target != null && target.isNavigable()) {
            ++targetType;
        }
        this.getPrimaryShape().setEnd(sourceType, targetType);
        super.refreshVisuals();
    }

    protected Property getSourceProperty() {
        IGraphicalEditPart graphicalSource = (IGraphicalEditPart)this.getSource();
        if (graphicalSource != null) {
            return this.getRelatedProperty(graphicalSource.resolveSemanticElement());
        }
        return null;
    }

    protected Property getTargetProperty() {
        IGraphicalEditPart graphicalTarget = (IGraphicalEditPart)this.getTarget();
        if (graphicalTarget != null) {
            return this.getRelatedProperty(graphicalTarget.resolveSemanticElement());
        }
        return null;
    }

    protected Property getRelatedProperty(EObject obj) {
        if (obj != null && this.resolveSemanticElement() instanceof Association) {
            EList ends = ((Association)this.resolveSemanticElement()).getMemberEnds();
            for (Property end : ends) {
                if (!obj.equals(end.getType())) continue;
                return end;
            }
        }
        return null;
    }
}

