/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.extension.BadClassNameException;
import org.eclipse.papyrus.infra.core.extension.ExtensionUtils;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiagramCategoryRegistry
extends ExtensionUtils {
    private static final String CATEGORY_EXTENSION_POINT_NAME = "org.eclipse.papyrus.infra.core.papyrusDiagram";
    public static final String CATEGORY_ELEMENT_NAME = "diagramCategory";
    private static final String CATEGORY_ID = "id";
    private static final String CATEGORY_LABEL = "label";
    private static final String CATEGORY_DESCRIPTION = "description";
    private static final String CATEGORY_ICON = "icon";
    private static final String CATEGORY_CLASS = "class";
    private static final String CATEGORY_FILE_EXTENSION_PREFIX = "extensionPrefix";
    private static Map<String, DiagramCategoryDescriptor> diagramCategories;
    private static DiagramCategoryRegistry ourInstance;

    private DiagramCategoryRegistry() {
    }

    public static DiagramCategoryRegistry getInstance() {
        if (ourInstance == null) {
            ourInstance = new DiagramCategoryRegistry();
        }
        return ourInstance;
    }

    public List<DiagramCategoryDescriptor> getDiagramCategories() {
        if (diagramCategories == null) {
            diagramCategories = this.buildDiagramCategories();
        }
        return new ArrayList<DiagramCategoryDescriptor>(diagramCategories.values());
    }

    public Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        if (diagramCategories == null) {
            diagramCategories = this.buildDiagramCategories();
        }
        return diagramCategories;
    }

    public Map<String, DiagramCategoryDescriptor> buildDiagramCategories() {
        HashMap<String, DiagramCategoryDescriptor> result = new HashMap<String, DiagramCategoryDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CATEGORY_EXTENSION_POINT_NAME);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement confElement = iConfigurationElementArray[n4];
                if (CATEGORY_ELEMENT_NAME.equals(confElement.getName())) {
                    try {
                        DiagramCategoryDescriptor diagramCategoryDescriptor = this.buildCategoryDescriptor(confElement);
                        result.put(diagramCategoryDescriptor.getId(), diagramCategoryDescriptor);
                    }
                    catch (BadClassNameException e) {
                        Activator.log.error(Messages.DiagramCategoryRegistry_bad_class_name_of_category, (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected DiagramCategoryDescriptor buildCategoryDescriptor(IConfigurationElement confElement) throws BadClassNameException {
        Class commandClazz = this.parseClass(confElement, CATEGORY_CLASS, CATEGORY_ELEMENT_NAME);
        DiagramCategoryDescriptor diagramCategoryDescriptor = new DiagramCategoryDescriptor(confElement.getAttribute(CATEGORY_ID), confElement.getAttribute(CATEGORY_LABEL), commandClazz);
        diagramCategoryDescriptor.setDescription(confElement.getAttribute(CATEGORY_DESCRIPTION));
        diagramCategoryDescriptor.setExtensionPrefix(confElement.getAttribute(CATEGORY_FILE_EXTENSION_PREFIX));
        String iconPath = confElement.getAttribute(CATEGORY_ICON);
        if (iconPath != null) {
            diagramCategoryDescriptor.setIcon(AbstractUIPlugin.imageDescriptorFromPlugin((String)confElement.getNamespaceIdentifier(), (String)iconPath));
        }
        return diagramCategoryDescriptor;
    }
}

