/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.kind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.viewpoints.configuration.Category;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class DiagramKindContentProvider
implements IStructuredContentProvider {
    private final Map<String, Collection<ViewPrototype>> prototypes;

    public DiagramKindContentProvider() {
        Collection vps = PolicyChecker.getCurrent().getAllPrototypes();
        this.prototypes = new HashMap<String, Collection<ViewPrototype>>();
        for (ViewPrototype vp : vps) {
            for (Category category : vp.getCategories()) {
                this.cache(category.getName(), vp);
            }
        }
    }

    private void cache(String category, ViewPrototype prototype) {
        if (!this.prototypes.containsKey(category)) {
            this.prototypes.put(category, new ArrayList());
        }
        this.prototypes.get(category).add(prototype);
    }

    public void dispose() {
        this.prototypes.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            ArrayList<ViewPrototype> result = new ArrayList<ViewPrototype>();
            Object[] objectArray = (Object[])inputElement;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object next = objectArray[n2];
                if (next instanceof String) {
                    String diagramCategory = (String)next;
                    result.addAll(this.getPrototypes(diagramCategory));
                }
                ++n2;
            }
            Collections.sort(result, new ViewPrototype.Comp());
            return result.toArray(new Object[result.size()]);
        }
        if (inputElement instanceof String) {
            String diagramCategory = (String)inputElement;
            List<ViewPrototype> result = this.getPrototypes(diagramCategory);
            return result.toArray(new Object[result.size()]);
        }
        return null;
    }

    protected List<ViewPrototype> getPrototypes(String diagramCategory) {
        HashMap<String, ViewPrototype> result = new HashMap<String, ViewPrototype>();
        if (this.prototypes.containsKey(diagramCategory)) {
            for (ViewPrototype prototype : this.prototypes.get(diagramCategory)) {
                String label = prototype.getLabel();
                if (result.containsKey(label)) continue;
                result.put(label, prototype);
            }
        }
        return new ArrayList<ViewPrototype>(result.values());
    }
}

