/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class PapyrusProjectCreationPage
extends WizardNewProjectCreationPage {
    private Text fileName;
    private Listener fileNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = PapyrusProjectCreationPage.this.canFlipToNextPage();
            PapyrusProjectCreationPage.this.setPageComplete(valid);
        }
    };

    public PapyrusProjectCreationPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        Group group = PapyrusProjectCreationPage.createGroup(composite, Messages.PapyrusProjectCreationPage_0);
        this.fileName = new Text((Composite)group, 2048);
        this.fileName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileName.setText(Messages.PapyrusProjectCreationPage_1);
        this.fileName.addListener(24, this.fileNameModifyListener);
        this.setPageComplete(false);
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    protected boolean validatePage() {
        if (this.fileName != null && this.fileName.getText().equals("")) {
            this.setErrorMessage(Messages.PapyrusProjectCreationPage_3);
            return false;
        }
        return super.validatePage();
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = true;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (canFlip) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iproject = iProjectArray[n2];
                if (this.getProjectName().equalsIgnoreCase(iproject.getName())) {
                    canFlip = false;
                    this.setErrorMessage(String.valueOf(Messages.PapyrusProjectCreationPage_page_same_case_desc) + iproject.getName());
                    break;
                }
                ++n2;
            }
        }
        if (!this.validatePage()) {
            canFlip = false;
        }
        return canFlip;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.NewProject");
    }
}

