/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.utils.SettingsHelper;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SelectDiagramCategoryPage
extends WizardPage {
    private final List<Button> myDiagramKindButtons = new ArrayList<Button>();
    private final List<String> mySelectedDiagramCategoryIds = new LinkedList<String>();
    public static final String PAGE_ID = "SelectDiagramCategory";
    public static final String DEFAULT_EXTENSION = "uml";
    private static final List<String> umlCore = Arrays.asList("UML", "Profile");
    private final boolean myAllowSeveralCategories;
    private SettingsHelper settingsHelper;
    private final Collator collator = Collator.getInstance();

    public SelectDiagramCategoryPage() {
        this(false);
    }

    public SelectDiagramCategoryPage(boolean allowSeveralCategories) {
        super(PAGE_ID);
        this.myAllowSeveralCategories = allowSeveralCategories;
        this.setTitle(Messages.SelectDiagramCategoryPage_select_language);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.settingsHelper = new SettingsHelper(this.getDialogSettings());
        String[] defaultDiagramCategory = this.settingsHelper.getDefaultDiagramCategories();
        if (defaultDiagramCategory != null && defaultDiagramCategory.length > 0) {
            String defaultSelection;
            String string = defaultSelection = Arrays.asList(defaultDiagramCategory).contains(DEFAULT_EXTENSION) ? DEFAULT_EXTENSION : defaultDiagramCategory[0];
            if (this.myAllowSeveralCategories) {
                this.setDefaultDiagramCategories(defaultDiagramCategory);
            } else {
                String previousSelection = this.settingsHelper.getPreviousSelection();
                if (this.settingsHelper.rememberCurrentSelection(this.getDialogSettings()) && previousSelection != null) {
                    this.setDefaultDiagramCategories(new String[]{previousSelection});
                } else {
                    this.setDefaultDiagramCategories(new String[]{defaultSelection});
                }
            }
        }
    }

    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        plate.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 10;
        plate.setLayout((Layout)gridLayout);
        this.setControl((Control)plate);
        this.createDiagramCategoryForm(plate);
        plate.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectDiagramCategoryPage.this.setPageComplete(SelectDiagramCategoryPage.this.validatePage());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(this.validatePage());
    }

    public String[] getDiagramCategories() {
        return this.mySelectedDiagramCategoryIds.toArray(new String[this.mySelectedDiagramCategoryIds.size()]);
    }

    protected final void setDefaultDiagramCategories(String[] categories) {
        this.mySelectedDiagramCategoryIds.clear();
        this.mySelectedDiagramCategoryIds.addAll(Arrays.asList(categories));
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        String[] categories = this.getDiagramCategories();
        if (categories == null || categories.length == 0) {
            this.setErrorMessage(Messages.SelectDiagramCategoryPage_select_one_category);
            return false;
        }
        return this.validateFileExtension(categories);
    }

    protected boolean validateFileExtension(String ... categories) {
        IStatus status = ((CreateModelWizard)this.getWizard()).diagramCategoryChanged(categories);
        switch (status.getSeverity()) {
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
            }
        }
        return true;
    }

    protected Map<String, DiagramCategoryDescriptor> getDiagramCategoryMap() {
        return DiagramCategoryRegistry.getInstance().getDiagramCategoryMap();
    }

    private void createDiagramCategoryForm(Composite composite) {
        Group group = SelectDiagramCategoryPage.createGroup(composite, Messages.SelectDiagramCategoryPage_diagram_language_group);
        this.collator.setStrength(1);
        Comparator<DiagramCategoryDescriptor> setComparator = new Comparator<DiagramCategoryDescriptor>(){

            @Override
            public int compare(DiagramCategoryDescriptor descriptor1, DiagramCategoryDescriptor descriptor2) {
                String button1Data = descriptor1.getLabel();
                String button2Data = descriptor2.getLabel();
                if (button2Data.equalsIgnoreCase(SelectDiagramCategoryPage.DEFAULT_EXTENSION)) {
                    return 1;
                }
                if (button1Data.equalsIgnoreCase(SelectDiagramCategoryPage.DEFAULT_EXTENSION)) {
                    return -1;
                }
                return SelectDiagramCategoryPage.this.collator.compare(button1Data, button2Data);
            }
        };
        TreeSet<DiagramCategoryDescriptor> descriptorUMLSet = new TreeSet<DiagramCategoryDescriptor>(setComparator);
        TreeSet<DiagramCategoryDescriptor> descriptorDSMLSet = new TreeSet<DiagramCategoryDescriptor>(setComparator);
        SelectionListener listener = new SelectionListener(){
            private SelectionEvent prevEvent;

            public void widgetSelected(SelectionEvent e) {
                if (e == this.prevEvent) {
                    return;
                }
                Button selected = (Button)e.widget;
                SelectDiagramCategoryPage.this.diagramCategorySelected((String)selected.getData(), selected.getSelection());
                SelectDiagramCategoryPage.this.setPageComplete(SelectDiagramCategoryPage.this.validatePage());
                this.prevEvent = e;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : this.getDiagramCategoryMap().values()) {
            String descriptorLabel = diagramCategoryDescriptor.getLabel();
            if (umlCore.contains(descriptorLabel)) {
                descriptorUMLSet.add(diagramCategoryDescriptor);
                continue;
            }
            descriptorDSMLSet.add(diagramCategoryDescriptor);
        }
        Label coreLabel = new Label((Composite)group, 0);
        coreLabel.setText(Messages.SelectDiagramCategoryPage_umlGroup);
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : descriptorUMLSet) {
            Button button = this.createCategoryButton(diagramCategoryDescriptor, group);
            button.addSelectionListener(listener);
            this.myDiagramKindButtons.add(button);
        }
        Label dsmlLabel = new Label((Composite)group, 0);
        dsmlLabel.setText(Messages.SelectDiagramCategoryPage_dsmlGroup);
        for (DiagramCategoryDescriptor diagramCategoryDescriptor : descriptorDSMLSet) {
            Button button = this.createCategoryButton(diagramCategoryDescriptor, group);
            button.addSelectionListener(listener);
            this.myDiagramKindButtons.add(button);
        }
        this.checkDiagramCategoryButtons();
        this.setDefaultSelection(DEFAULT_EXTENSION);
    }

    private void setDefaultSelection(String defaultExtension) {
        String previousSelection = this.settingsHelper.getPreviousSelection();
        String defaultSelection = previousSelection != null ? previousSelection : defaultExtension;
        for (Button button : this.myDiagramKindButtons) {
            if (!defaultSelection.equalsIgnoreCase((String)button.getData())) continue;
            button.setSelection(true);
            this.diagramCategorySelected(defaultSelection, button.getSelection());
        }
    }

    protected void diagramCategorySelected(String category, boolean checked) {
        if (checked) {
            if (!this.mySelectedDiagramCategoryIds.contains(category)) {
                this.mySelectedDiagramCategoryIds.add(category);
            }
        } else {
            this.mySelectedDiagramCategoryIds.remove(category);
        }
        this.settingsHelper.setCurrentSelection(category);
        this.settingsHelper.saveRememberCurrentSelection(true);
    }

    protected void checkDiagramCategoryButtons() {
        this.checkButtonsFor(this.mySelectedDiagramCategoryIds.toArray(new String[this.mySelectedDiagramCategoryIds.size()]));
    }

    protected void checkButtonsFor(String ... diagramCategories) {
        for (Button button : this.myDiagramKindButtons) {
            button.setSelection(false);
        }
        for (Button button : this.myDiagramKindButtons) {
            String[] stringArray = diagramCategories;
            int n = diagramCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String diagramCategory = stringArray[n2];
                if (diagramCategory.equalsIgnoreCase((String)button.getData())) {
                    button.setSelection(true);
                }
                ++n2;
            }
        }
    }

    private Button createCategoryButton(DiagramCategoryDescriptor diagramCategoryDescriptor, Group group) {
        Button button = new Button((Composite)group, this.myAllowSeveralCategories ? 32 : 16);
        button.setText(diagramCategoryDescriptor.getLabel());
        button.setData((Object)diagramCategoryDescriptor.getId());
        Image image = SelectDiagramCategoryPage.getImage(diagramCategoryDescriptor.getIcon());
        if (image != null) {
            button.setImage(image);
        }
        button.setToolTipText(diagramCategoryDescriptor.getDescription());
        return button;
    }

    private static Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor != null) {
            return new Image(null, imageDescriptor.getImageData());
        }
        return null;
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.Category");
    }
}

