/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.standard;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementExtensionPoint;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementsDetailsLabelProvider;
import org.eclipse.papyrus.uml.extensionpoints.standard.RegisteredElementsLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredRegisteredElementsSelectionDialog
extends FilteredItemsSelectionDialog {
    protected static final String DIALOG_SETTINGS = "org.eclipse.papyrus.uml.extensionpointsdialogs.registeredelement";
    private RegisteredElementsLabelProvider registeredElementsLabelProvider;
    private RegisteredElementsDetailsLabelProvider registeredElementsDetailsLabelProvider;
    Object[] totalInput;
    Collection<Object> alreadySelected;
    private TableViewer selectedElementList;
    private ArrayContentProvider contentProvider;
    protected String extendedAreaTitle;

    public FilteredRegisteredElementsSelectionDialog(Shell shell, boolean multi, Object[] input, Collection<Object> alreadySelected, String title, String extendedAreaTitle) {
        super(shell, multi);
        this.setTitle(title);
        this.setInitialPattern("**");
        this.totalInput = input;
        this.extendedAreaTitle = extendedAreaTitle;
        this.alreadySelected = alreadySelected;
        this.registeredElementsLabelProvider = new RegisteredElementsLabelProvider();
        this.registeredElementsDetailsLabelProvider = new RegisteredElementsDetailsLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.registeredElementsLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.registeredElementsDetailsLabelProvider);
        this.contentProvider = new ArrayContentProvider();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.createExtendedAreaHeader(content);
        this.selectedElementList = new TableViewer(content, 0x10000A00);
        this.selectedElementList.setContentProvider((IContentProvider)this.contentProvider);
        this.selectedElementList.setLabelProvider((IBaseLabelProvider)this.registeredElementsLabelProvider);
        this.selectedElementList.setInput(this.alreadySelected);
        this.selectedElementList.setItemCount(this.contentProvider.getElements(this.alreadySelected).length);
        gd = new GridData(1808);
        this.selectedElementList.getTable().setLayoutData((Object)gd);
        return content;
    }

    protected void createExtendedAreaHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        Label label = new Label(header, 0);
        label.setText(String.valueOf(this.extendedAreaTitle) + " (Read-only table)");
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        header.setLayoutData((Object)gd);
    }

    public String getElementName(Object item) {
        return this.registeredElementsLabelProvider.getText(item);
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.papyrus.uml.extensionpoints", "");
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new RegisteredElementExtensionPointFilter(this){};
    }

    protected Comparator<RegisteredElementExtensionPoint> getItemsComparator() {
        Comparator<RegisteredElementExtensionPoint> comp = new Comparator<RegisteredElementExtensionPoint>(){

            @Override
            public int compare(RegisteredElementExtensionPoint o1, RegisteredElementExtensionPoint o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        return comp;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        if (progressMonitor != null) {
            progressMonitor.beginTask("Displaying registered elements", this.totalInput.length);
        }
        int i = 0;
        while (i < this.totalInput.length) {
            Object o = this.totalInput[i];
            if (!this.alreadySelected.contains(o)) {
                contentProvider.add(o, itemsFilter);
            }
            progressMonitor.worked(1);
            ++i;
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    private class RegisteredElementExtensionPointFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private RegisteredElementExtensionPointFilter() {
            super((FilteredItemsSelectionDialog)FilteredRegisteredElementsSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof RegisteredElementExtensionPoint;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof RegisteredElementExtensionPoint)) {
                return false;
            }
            return this.matches(FilteredRegisteredElementsSelectionDialog.this.registeredElementsLabelProvider.getText(item));
        }
    }
}

