/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.xtext.valuespecification.manager.cell;

import com.google.inject.Injector;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.nattable.manager.cell.EMFFeatureValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.ui.internal.UmlValueSpecificationActivator;
import org.eclipse.papyrus.uml.textedit.valuespecification.xtext.utils.commands.ValueSpecificationSetCommand;
import org.eclipse.uml2.uml.UMLPackage;

public class ValueSpecificationCellManager
extends EMFFeatureValueCellManager {
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        if (newValue instanceof IAdaptable) {
            ICommand cmd = (ICommand)((IAdaptable)newValue).getAdapter(ICommand.class);
            if (cmd != null && cmd.canExecute()) {
                return new GMFtoEMFCommandWrapper(cmd);
            }
            String editedString = (String)((IAdaptable)newValue).getAdapter(String.class);
            return this.getSetStringValueCommand(domain, columnElement, rowElement, editedString, null, tableManager);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueSolver, INattableModelManager tableManager) {
        if (columnElement instanceof EStructuralFeatureAxis && rowElement instanceof EObjectAxis || columnElement instanceof EObjectAxis && rowElement instanceof EStructuralFeatureAxis) {
            EStructuralFeature structuralFeature = null;
            structuralFeature = columnElement instanceof EStructuralFeatureAxis ? ((EStructuralFeatureAxis)columnElement).getElement() : ((EStructuralFeatureAxis)rowElement).getElement();
            if (UMLPackage.Literals.VALUE_SPECIFICATION == structuralFeature.getEType()) {
                EObject eObject = null;
                eObject = rowElement instanceof EObjectAxis ? ((EObjectAxis)rowElement).getElement() : ((EObjectAxis)columnElement).getElement();
                CompositeCommand result = ValueSpecificationSetCommand.getInstance().createSetCommand(this.getInjector(), eObject, structuralFeature, newValue, this.getDefaultLanguages());
                return result.isEmpty() ? null : new GMFtoEMFCommandWrapper((ICommand)result);
            }
        }
        return null;
    }

    protected Collection<String> getDefaultLanguages() {
        return Collections.emptyList();
    }

    public Injector getInjector() {
        return UmlValueSpecificationActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.valuespecification.xtext.UmlValueSpecification");
    }

    public boolean handles(Object columnElement, Object rowElement) {
        boolean result = false;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        Object column = AxisUtils.getRepresentedElement((Object)columnElement);
        if (column instanceof EStructuralFeature) {
            result = UMLPackage.Literals.VALUE_SPECIFICATION == ((EStructuralFeature)column).getEType();
        } else if (row instanceof EStructuralFeature) {
            result = UMLPackage.Literals.VALUE_SPECIFICATION == ((EStructuralFeature)row).getEType();
        }
        return result;
    }
}

