/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.IIdAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLFeatureAxisManager;
import org.eclipse.papyrus.uml.nattable.provider.UMLStereotypeRestrictedPropertyContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypePropertyAxisManager
extends UMLFeatureAxisManager
implements IIdAxisManager {
    @Override
    public boolean isAllowedContents(Object object) {
        Property prop;
        Element owner;
        boolean result = false;
        if (object instanceof Property && (owner = (prop = (Property)object).getOwner()) instanceof Stereotype) {
            while (owner.getOwner() instanceof Package && !result) {
                owner = owner.getOwner();
                result = owner instanceof Profile;
            }
            if (result) {
                result = EMFHelper.isReadOnly((EObject)prop);
            }
        }
        return result;
    }

    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        HashSet appliedStereotypes = new HashSet();
        for (Object current : objectToAdd) {
            if (!(current instanceof Element)) continue;
            appliedStereotypes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet<Object> propertiesToAdd = new HashSet<Object>();
        for (Stereotype stereotype : appliedStereotypes) {
            propertiesToAdd.addAll(StereotypeUtil.getAllStereotypePropertiesWithoutBaseProperties((Stereotype)stereotype));
        }
        if (!propertiesToAdd.isEmpty()) {
            return this.getAddAxisCommand(domain, propertiesToAdd);
        }
        return null;
    }

    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        ArrayList<String> allPropertyQN = new ArrayList<String>();
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object)) continue;
            allPropertyQN.add("property_of_stereotype:/" + ((NamedElement)object).getQualifiedName());
        }
        allPropertyQN.removeAll(this.getElements());
        if (!allPropertyQN.isEmpty()) {
            ArrayList<FeatureIdAxis> toAdd = new ArrayList<FeatureIdAxis>();
            for (String propQN : allPropertyQN) {
                FeatureIdAxis newAxis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
                newAxis.setElement(propQN);
                newAxis.setManager(this.representedAxisManager);
                toAdd.add(newAxis);
                this.managedObject.add(propQN);
            }
            if (!toAdd.isEmpty()) {
                return AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd);
            }
        }
        return null;
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        return new UMLStereotypeRestrictedPropertyContentProvider(this, isRestricted);
    }

    @Override
    public Collection<Object> getAllPossibleAxis() {
        return this.getRootProfiles();
    }

    private Collection<Object> getRootProfiles() {
        EObject context = this.getTableManager().getTable().getContext();
        assert (context instanceof Element);
        EList allAppliedProfiles = ((Element)context).getNearestPackage().getAllAppliedProfiles();
        HashSet<Object> profiles = new HashSet<Object>();
        for (Profile profile : allAppliedProfiles) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)profile);
            profiles.add(rootContainer);
        }
        return profiles;
    }

    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> umlProperties) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        ArrayList<String> propIdToDestroy = new ArrayList<String>();
        for (Object current : umlProperties) {
            if (!(current instanceof Property) || !(((Property)current).eContainer() instanceof Stereotype)) continue;
            propIdToDestroy.add("property_of_stereotype:/" + ((NamedElement)current).getQualifiedName());
        }
        for (Object current : this.getRepresentedContentProvider().getAxis()) {
            String propId;
            if (!(current instanceof IdAxis) || !propIdToDestroy.contains(propId = AxisUtils.getPropertyId((Object)current))) continue;
            DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new GMFtoEMFCommandWrapper((ICommand)compositeCommand);
        }
        return null;
    }

    public Object resolvedPath(String path) {
        if (path.startsWith("property_of_stereotype:/")) {
            return UMLTableUtils.getRealStereotypeProperty(this.getTableContext(), path);
        }
        return null;
    }
}

