/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.Activator;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLStereotypePropertyAxisManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.uml2.uml.Property;

public abstract class AbstractCreateStereotypePropertyMenuFactory
extends ExtensionContributionFactory {
    private final String menuLabel;
    private final String iconPath;

    public AbstractCreateStereotypePropertyMenuFactory(String menuLabel, String iconPath) {
        this.menuLabel = menuLabel;
        this.iconPath = iconPath;
    }

    protected abstract UMLStereotypePropertyAxisManager getStereotypeAxisManager(INattableModelManager var1);

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        INattableModelManager tableManager = this.getTableManager();
        if (tableManager != null) {
            UMLStereotypePropertyAxisManager steretoypeAxisManager = this.getStereotypeAxisManager(tableManager);
            if (steretoypeAxisManager == null) {
                return;
            }
            IRestrictedContentProvider provider = steretoypeAxisManager.createPossibleAxisContentProvider(true);
            HierarchicToFlatContentProvider flatProvider = new HierarchicToFlatContentProvider((IHierarchicContentProvider)provider);
            Object[] elementss = flatProvider.getElements();
            final HashMap<String, Property> nameToPropertyMap = new HashMap<String, Property>();
            Object[] objectArray = elementss;
            int n = elementss.length;
            int n2 = 0;
            while (n2 < n) {
                Object current = objectArray[n2];
                if (current instanceof Property) {
                    nameToPropertyMap.put(((Property)current).getQualifiedName(), (Property)current);
                }
                ++n2;
            }
            final ArrayList<String> initialSelection = new ArrayList<String>();
            for (Object current : this.getAxisElementList(tableManager)) {
                String el;
                if (!(current instanceof FeatureIdAxis) || !(el = ((FeatureIdAxis)current).getElement()).startsWith("property_of_stereotype:/")) continue;
                initialSelection.add(((FeatureIdAxis)current).getElement().replace("property_of_stereotype:/", ""));
            }
            if (tableManager != null) {
                MenuManager manager = new MenuManager(this.menuLabel){

                    public void fill(Menu parent, int index) {
                        super.fill(parent, index);
                        this.getMenu().getParentItem().setEnabled(true);
                        org.eclipse.papyrus.infra.widgets.Activator activator = org.eclipse.papyrus.infra.widgets.Activator.getDefault();
                        Activator.getDefault();
                        Image image = activator.getImage("org.eclipse.papyrus.uml.nattable", AbstractCreateStereotypePropertyMenuFactory.this.iconPath);
                        this.getMenu().getParentItem().setImage(image);
                    }
                };
                manager.setVisible(true);
                ContributionItem item = new ContributionItem(){

                    public void fill(Menu menu, int index) {
                        AbstractCreateStereotypePropertyMenuFactory.this.fillMenu(menu, initialSelection, nameToPropertyMap);
                    }
                };
                Menu menu = manager.getMenu();
                if (menu != null) {
                    menu.setEnabled(false);
                }
                manager.add((IContributionItem)item);
                Expression visibleWhen = new Expression(){

                    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                        return EvaluationResult.TRUE;
                    }
                };
                additions.addContributionItem((IContributionItem)manager, visibleWhen);
            }
        }
    }

    protected abstract void fillMenu(Menu var1, Collection<String> var2, Map<String, Property> var3);

    @Deprecated
    protected abstract void fillMenu(Menu var1, INattableModelManager var2, Collection<String> var3, Map<String, Property> var4);

    protected abstract Collection<?> getAxisElementList(INattableModelManager var1);

    protected final INattableModelManager getTableManager() {
        IWorkbenchPart workbenchPart = EditorHelper.getActivePart();
        INattableModelManager tableManager = null;
        if (workbenchPart != null) {
            tableManager = (INattableModelManager)workbenchPart.getAdapter(INattableModelManager.class);
        }
        return tableManager;
    }
}

