/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.provider.GenericCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class AbstractUMLNattableCellLabelProvider
extends GenericCellLabelProvider {
    protected List<Object> getUMLObjects(Object obj1, Object obj2) {
        List<Object> objects = new ArrayList<Object>();
        if (obj1 instanceof Element) {
            objects.add(obj1);
            objects.add(obj2);
        } else if (obj2 instanceof Element) {
            objects.add(obj2);
            objects.add(obj1);
        }
        if (objects.size() == 2) {
            Object feature = objects.get(1);
            String id = AxisUtils.getPropertyId(feature);
            if (id != null) {
                if (id.startsWith("property_of_stereotype:/")) {
                    Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)objects.get(0), id);
                    if (prop != null) {
                        objects.remove(1);
                        objects.add(prop);
                    } else {
                        objects = Collections.emptyList();
                    }
                }
            } else if (feature instanceof EStructuralFeature) {
                EObject featureContainer = ((EStructuralFeature)feature).eContainer();
                if (!UMLPackage.eINSTANCE.eContents().contains((Object)featureContainer)) {
                    objects = Collections.emptyList();
                }
            }
        } else {
            objects = Collections.emptyList();
        }
        return objects;
    }
}

