/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CrossAxisWrapper;
import org.eclipse.papyrus.uml.nattable.paste.StereotypeApplicationStructure;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLTableUtils {
    public static final String PROPERTY_OF_STEREOTYPE_PREFIX = "property_of_stereotype:/";

    private UMLTableUtils() {
    }

    public static final boolean isStringRepresentingStereotypeProperty(String aString) {
        return aString.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX);
    }

    public static final boolean isStringRepresentingStereotypeProperty(Object anAxis) {
        if ((anAxis = AxisUtils.getRepresentedElement((Object)anAxis)) instanceof String) {
            return UMLTableUtils.isStringRepresentingStereotypeProperty((String)anAxis);
        }
        return false;
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id) {
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element) {
            Element element = (Element)eobject;
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
            ArrayList<String> subPackages = new ArrayList<String>();
            if (element.getNearestPackage() != null) {
                Profile profile = element.getNearestPackage().getAppliedProfile(profileQN, true);
                if (profile == null) {
                    if (profileQN.contains("::")) {
                        String[] split = profileQN.split("::");
                        profileQN = split[0];
                        int splitIndex = 1;
                        while (splitIndex < split.length) {
                            subPackages.add(split[splitIndex]);
                            ++splitIndex;
                        }
                    }
                    profile = element.getNearestPackage().getAppliedProfile(profileQN, true);
                }
                if (profile != null) {
                    Profile currentPackage = profile;
                    Iterator subPackagesIterator = subPackages.iterator();
                    while (currentPackage != null && subPackagesIterator.hasNext()) {
                        NamedElement namedElement = currentPackage.getOwnedMember((String)subPackagesIterator.next());
                        Package package_ = currentPackage = namedElement instanceof Package ? (Package)namedElement : null;
                    }
                    if (currentPackage != null) {
                        Stereotype ste = currentPackage.getOwnedStereotype(stereotypeName);
                        return (Property)ste.getMember(propertyName);
                    }
                }
            }
            return UMLTableUtils.getProperty((Collection<Package>)element.getNearestPackage().getNestedPackages(), propertyQN);
        }
        return null;
    }

    protected static Property getProperty(Collection<Package> packages, String propertyQN) {
        String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
        String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
        String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
        String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
        for (Package package1 : packages) {
            for (Profile prof : package1.getAppliedProfiles()) {
                NamedElement prop;
                NamedElement ste;
                if (prof.getQualifiedName().equals(profileQN) && (ste = prof.getMember(stereotypeName)) instanceof Stereotype && (prop = ((Stereotype)ste).getMember(propertyName)) instanceof Property && prop.getQualifiedName().equals(propertyQN)) {
                    return (Property)prop;
                }
                Property p = UMLTableUtils.getProperty((Collection<Package>)package1.getNestedPackages(), propertyQN);
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    public static final List<Enumerator> getLiteralsToTypeProperty(EObject modelElement, String id) {
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (modelElement instanceof Element) {
            Property property = UMLTableUtils.getRealStereotypeProperty(modelElement, id);
            Stereotype current = (Stereotype)property.getOwner();
            EClass stereotypeDef = (EClass)current.getProfile().getDefinition((NamedElement)current);
            EStructuralFeature feature = stereotypeDef.getEStructuralFeature(property.getName());
            EEnum eenum = null;
            if (feature != null && feature.getEType() instanceof EEnum) {
                eenum = (EEnum)feature.getEType();
            }
            if (eenum != null) {
                ArrayList<Enumerator> literals = new ArrayList<Enumerator>();
                for (EEnumLiteral literal : eenum.getELiterals()) {
                    Enumerator value = literal.getInstance();
                    literals.add(value);
                }
                return literals;
            }
        }
        return Collections.emptyList();
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id, Map<?, ?> sharedMap) {
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element) {
            Profile profile;
            Package nearestPackage;
            Element element = (Element)eobject;
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
            if (sharedMap != null) {
                Element context = (Element)sharedMap.get("pastedElementContainer");
                nearestPackage = context.getNearestPackage();
            } else {
                nearestPackage = element.getNearestPackage();
            }
            if (nearestPackage != null && (profile = nearestPackage.getAppliedProfile(profileQN, true)) != null) {
                Stereotype ste = profile.getOwnedStereotype(stereotypeName);
                return (Property)ste.getMember(propertyName);
            }
        }
        return null;
    }

    public static final List<Stereotype> getAppliedStereotypesWithThisProperty(Element element, String id) {
        Property prop;
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id)) instanceof Property) {
            for (Stereotype current : element.getAppliedStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }

    public static final List<Stereotype> getApplicableStereotypesWithThisProperty(Element element, String id) {
        Property prop;
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id)) instanceof Property) {
            for (Stereotype current : element.getApplicableStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }

    public static final List<Stereotype> getAppliedStereotypesWithThisProperty(Element element, String id, Map<?, ?> sharedMap) {
        Property prop;
        List<StereotypeApplicationStructure> struct;
        Assert.isTrue((boolean)id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        if (sharedMap != null && (struct = UMLTableUtils.findStereotypeApplicationDataStructure(element, id, sharedMap)) != null) {
            for (StereotypeApplicationStructure current : struct) {
                stereotypes.add(current.getStereotype());
            }
        }
        if (element.eResource() != null && (prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id, sharedMap)) instanceof Property) {
            for (StereotypeApplicationStructure current : element.getAppliedStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add((Stereotype)current);
            }
        }
        return stereotypes;
    }

    public static final List<StereotypeApplicationStructure> findStereotypeApplicationDataStructure(Element editedElement, String id, Map<?, ?> sharedMap) {
        List list = (List)sharedMap.get(editedElement);
        if (list != null && !list.isEmpty()) {
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            for (StereotypeApplicationStructure current : list) {
                if (!current.getProperty().getQualifiedName().equals(propertyQN)) continue;
                return Collections.singletonList(current);
            }
        }
        return null;
    }

    public static CrossAxisWrapper<EObject, EStructuralFeature> getRealEditedObject(ILayerCell layerCell, ITableAxisElementProvider manager) {
        int columnIndex = layerCell.getColumnIndex();
        int rowIndex = layerCell.getRowIndex();
        Object row = manager.getRowElement(rowIndex);
        Object column = manager.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        Element editedElement = null;
        Object feature = null;
        if (row instanceof Element && !(column instanceof Element)) {
            editedElement = (Element)row;
            feature = column;
        } else if (column instanceof Element && !(row instanceof Element)) {
            editedElement = (Element)column;
            feature = row;
        } else {
            return null;
        }
        EStructuralFeature realFeature = null;
        Element realEditedObject = null;
        List<Stereotype> stereotypesWithEditedFeatureAppliedOnElement = null;
        if (feature instanceof EStructuralFeature) {
            realFeature = (EStructuralFeature)feature;
            realEditedObject = editedElement;
        } else if (feature instanceof String && ((String)feature).startsWith(PROPERTY_OF_STEREOTYPE_PREFIX)) {
            String id = AxisUtils.getPropertyId((Object)feature);
            stereotypesWithEditedFeatureAppliedOnElement = UMLTableUtils.getAppliedStereotypesWithThisProperty(editedElement, id);
            realEditedObject = editedElement.getStereotypeApplication(stereotypesWithEditedFeatureAppliedOnElement.get(0));
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)editedElement, id);
            realFeature = realEditedObject.eClass().getEStructuralFeature(prop.getName());
        }
        if (stereotypesWithEditedFeatureAppliedOnElement != null && stereotypesWithEditedFeatureAppliedOnElement.size() > 1) {
            return null;
        }
        if (realEditedObject != null && realFeature != null) {
            return new CrossAxisWrapper((Object)realEditedObject, (Object)realFeature);
        }
        return null;
    }
}

