/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.assistants.generator;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.infra.elementtypesconfigurations.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.assistant.AssistantFactory;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ConnectionAssistant;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.PopupAssistant;
import org.eclipse.papyrus.uml.profile.assistants.generator.ConnectionAssistantRule;
import org.eclipse.papyrus.uml.profile.assistants.generator.FiltersUtil;
import org.eclipse.papyrus.uml.profile.assistants.generator.PopupAssistantRule;
import org.eclipse.papyrus.uml.profile.elementtypesconfigurations.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.elementtypesconfigurations.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.elementtypesconfigurations.generator.UML;
import org.eclipse.papyrus.uml.profile.elementtypesconfigurations.generator.UMLElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class ModelingAssistantProviderRule {
    @Extension
    private static AssistantFactory assistantFactory = AssistantFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private FiltersUtil _filtersUtil;
    @Inject
    @Extension
    private PopupAssistantRule _popupAssistantRule;
    @Inject
    @Extension
    private ConnectionAssistantRule _connectionAssistantRule;
    private final HashMap<ArrayList<?>, ModelingAssistantProvider> _createCache_toModelingAssistantProvider = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelingAssistantProvider toModelingAssistantProvider(Profile umlProfile) {
        ModelingAssistantProvider _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ModelingAssistantProvider> hashMap = this._createCache_toModelingAssistantProvider;
        synchronized (hashMap) {
            ModelingAssistantProvider _createModelingAssistantProvider;
            if (this._createCache_toModelingAssistantProvider.containsKey(_cacheKey)) {
                return this._createCache_toModelingAssistantProvider.get(_cacheKey);
            }
            _result = _createModelingAssistantProvider = assistantFactory.createModelingAssistantProvider();
            this._createCache_toModelingAssistantProvider.put(_cacheKey, _result);
        }
        this._init_toModelingAssistantProvider(_result, umlProfile);
        return _result;
    }

    private void _init_toModelingAssistantProvider(final ModelingAssistantProvider it, final Profile umlProfile) {
        this._identifiers.setIdentifierBase((Package)umlProfile);
        String _name = umlProfile.getName();
        it.setName(_name);
        Iterable _allExtensions = this._uML.getAllExtensions((Package)umlProfile);
        Procedures.Procedure1<ImpliedExtension> _function = new Procedures.Procedure1<ImpliedExtension>(){

            public void apply(final ImpliedExtension ext) {
                boolean _not;
                Class _metaclass = ext.getMetaclass();
                Iterable _diagramSpecificElementTypes = ModelingAssistantProviderRule.this._uMLElementTypes.getDiagramSpecificElementTypes(_metaclass);
                Functions.Function1<ElementTypeConfiguration, String> _function = new Functions.Function1<ElementTypeConfiguration, String>(){

                    public String apply(ElementTypeConfiguration it) {
                        return ModelingAssistantProviderRule.this._identifiers.toElementTypeID(ext, it);
                    }
                };
                Iterable profileElementTypes = IterableExtensions.map((Iterable)_diagramSpecificElementTypes, (Functions.Function1)_function);
                Procedures.Procedure1<String> _function_1 = new Procedures.Procedure1<String>(){

                    public void apply(String it) {
                        ModelingAssistantProviderRule.this._filtersUtil.toElementTypeFilter(it, umlProfile);
                    }
                };
                IterableExtensions.forEach((Iterable)profileElementTypes, (Procedures.Procedure1)_function_1);
                Class _metaclass_1 = ext.getMetaclass();
                EClass _eClass = ModelingAssistantProviderRule.this._uMLElementTypes.getEClass(_metaclass_1);
                boolean _isRelationship = ModelingAssistantProviderRule.this._uML.isRelationship(_eClass);
                boolean bl = _not = !_isRelationship;
                if (_not) {
                    EList _elementTypeIDs = it.getElementTypeIDs();
                    Iterables.addAll((Collection)_elementTypeIDs, (Iterable)profileElementTypes);
                    EList _popupAssistants = it.getPopupAssistants();
                    Class _metaclass_2 = ext.getMetaclass();
                    Iterable _diagramSpecificElementTypes_1 = ModelingAssistantProviderRule.this._uMLElementTypes.getDiagramSpecificElementTypes(_metaclass_2);
                    Functions.Function1<ElementTypeConfiguration, PopupAssistant> _function_2 = new Functions.Function1<ElementTypeConfiguration, PopupAssistant>(){

                        public PopupAssistant apply(ElementTypeConfiguration it) {
                            return ModelingAssistantProviderRule.this._popupAssistantRule.toPopupAssistant(ext, it);
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_diagramSpecificElementTypes_1, (Functions.Function1)_function_2);
                    Iterables.addAll((Collection)_popupAssistants, (Iterable)_map);
                } else {
                    EList _relationshipTypeIDs = it.getRelationshipTypeIDs();
                    Iterables.addAll((Collection)_relationshipTypeIDs, (Iterable)profileElementTypes);
                    EList _connectionAssistants = it.getConnectionAssistants();
                    Class _metaclass_3 = ext.getMetaclass();
                    Iterable _diagramSpecificElementTypes_2 = ModelingAssistantProviderRule.this._uMLElementTypes.getDiagramSpecificElementTypes(_metaclass_3);
                    Functions.Function1<ElementTypeConfiguration, ConnectionAssistant> _function_3 = new Functions.Function1<ElementTypeConfiguration, ConnectionAssistant>(){

                        public ConnectionAssistant apply(ElementTypeConfiguration it) {
                            return ModelingAssistantProviderRule.this._connectionAssistantRule.toConnectionAssistant(ext, it);
                        }
                    };
                    Iterable _map_1 = IterableExtensions.map((Iterable)_diagramSpecificElementTypes_2, (Functions.Function1)_function_3);
                    Iterables.addAll((Collection)_connectionAssistants, (Iterable)_map_1);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_allExtensions, (Procedures.Procedure1)_function);
    }
}

