/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.providers;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.uml.profile.utils.Util;
import org.eclipse.papyrus.uml.tools.profile.definition.Version;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

public class ProfileApplicationLabelProvider
extends StyledCellLabelProvider {
    private static final int PACKAGE_ELEMENT_COLUMN_INDEX = 0;
    private static final int PROFILE_APPLICATION_UPDATE_VERSION_COLUMN_INDEX = 3;
    private static final int PROFILE_APPLICATION_NAME_COLUMN_INDEX = 2;
    private static final int PROFILE_APPLICATION_VERSION_COLUMN_INDEX = 1;
    private final ILabelProvider umlLabelProvider = new UMLLabelProvider();

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int columnIndex = cell.getColumnIndex();
        StyledString styledText = this.getStyledText(element, columnIndex);
        cell.setText(styledText.getString());
        cell.setStyleRanges(styledText.getStyleRanges());
        cell.setImage(this.getImage(element, columnIndex));
    }

    protected StyledString getStyledText(Object element, int columnIndex) {
        return new StyledString(this.getText(element, columnIndex));
    }

    private Version extractProfileApplicationVersion(ProfileApplication profileApplication) {
        EPackage appliedDefinition;
        Version version = null;
        EAnnotation versionAnnotation = profileApplication.getEAnnotation("PapyrusVersion");
        if (versionAnnotation == null && (appliedDefinition = profileApplication.getAppliedDefinition()) != null) {
            versionAnnotation = appliedDefinition.getEAnnotation("PapyrusVersion");
        }
        if (versionAnnotation != null) {
            String versionValue = (String)versionAnnotation.getDetails().get((Object)"Version");
            version = new Version(versionValue);
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        return version;
    }

    protected String getText(Object element, int columnIndex) {
        String result = null;
        if (element instanceof ProfileApplication) {
            ProfileApplication profileApplication = (ProfileApplication)element;
            switch (columnIndex) {
                case 0: {
                    result = this.umlLabelProvider.getText((Object)profileApplication.getAppliedProfile());
                    break;
                }
                case 1: {
                    Version profileVersion = this.extractProfileApplicationVersion(profileApplication);
                    result = profileVersion.toString();
                    break;
                }
                case 2: {
                    Profile appliedProfile = profileApplication.getAppliedProfile();
                    if (appliedProfile == null) {
                        result = "<Missing Profile>";
                        break;
                    }
                    if (appliedProfile.eIsProxy()) {
                        EPackage definition = profileApplication.getAppliedDefinition();
                        if (definition != null) {
                            result = this.umlLabelProvider.getText((Object)definition);
                            break;
                        }
                        result = "<Unresolved Profile>";
                        break;
                    }
                    result = appliedProfile.getQualifiedName();
                    break;
                }
                case 3: {
                    Version latestProfileVersion = Util.getProfileDefinitionVersion(profileApplication.getAppliedProfile());
                    result = latestProfileVersion.toString();
                    break;
                }
            }
        } else {
            switch (columnIndex) {
                case 0: {
                    result = this.umlLabelProvider.getText(element);
                    break;
                }
            }
        }
        return result == null ? "" : result;
    }

    protected Image getImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.umlLabelProvider.getImage(element);
            }
            case 2: {
                if (!(element instanceof ProfileApplication)) break;
                return this.umlLabelProvider.getImage((Object)((ProfileApplication)element).getAppliedProfile());
            }
        }
        return null;
    }

    public void dispose() {
        this.umlLabelProvider.dispose();
        super.dispose();
    }
}

