/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.service.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.uml.profile.providers.ProfileApplicationContentProvider;
import org.eclipse.papyrus.uml.profile.providers.ProfileApplicationLabelProvider;
import org.eclipse.papyrus.uml.tools.helper.IProfileApplicationDelegate;
import org.eclipse.papyrus.uml.tools.helper.ProfileApplicationDelegateRegistry;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshProfileDialog
extends SelectionDialog {
    protected final Map<Package, Collection<Profile>> profilesToReapply;
    protected Runnable callback;
    protected Package rootPackage;

    public RefreshProfileDialog(Shell parentShell, Package rootPackage) {
        super(parentShell);
        this.setBlockOnOpen(false);
        this.rootPackage = rootPackage;
        this.profilesToReapply = new HashMap<Package, Collection<Profile>>();
        this.setTitle("Some profiles have changed");
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    public void create() {
        super.create();
        Label descriptionLabel = new Label(this.getDialogArea(), 64);
        descriptionLabel.setText("Some local profiles have changed. Select the ones you want to re-apply");
        TreeViewer viewer = new TreeViewer(this.getDialogArea());
        viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        Tree tree = viewer.getTree();
        TableLayout layout = new TableLayout();
        TreeColumn propertyColumn = new TreeColumn(tree, 0x1000000);
        propertyColumn.setText("Package");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 300, true));
        TreeColumn propertyVersionColumn = new TreeColumn(tree, 0x1000000);
        propertyVersionColumn.setText("Version");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 100, true));
        TreeColumn ownerColumn = new TreeColumn(tree, 0x1000000);
        ownerColumn.setText("Profile");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 150, true));
        TreeColumn ownerVersionColumn = new TreeColumn(tree, 0x1000000);
        ownerVersionColumn.setText("Version");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, 100, true));
        TreeColumn checkColumn = new TreeColumn(tree, 0x1000000);
        checkColumn.setText("Reapply");
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 70, true));
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new ProfileApplicationContentProvider(this.rootPackage));
        viewer.setLabelProvider((IBaseLabelProvider)new ProfileApplicationLabelProvider());
        viewer.setInput(new Object());
        this.installEditors(viewer);
        this.getDialogArea().layout();
        this.getShell().pack();
    }

    protected void installEditors(TreeViewer viewer) {
        viewer.expandAll();
        TreeItem[] treeItemArray = viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.installEditors(item, this.rootPackage);
            ++n2;
        }
    }

    protected void installEditors(TreeItem treeItem, Object parentPackage) {
        Object currentDataItem = treeItem.getData();
        if (currentDataItem instanceof ProfileApplication) {
            ProfileApplication profileApplication = (ProfileApplication)currentDataItem;
            Tree tree = treeItem.getParent();
            final Button checkbox = new Button((Composite)tree, 32);
            checkbox.setSelection(true);
            IProfileApplicationDelegate delegate = this.getDelegate(profileApplication);
            final Package applyingPackage = delegate.getApplyingPackage(profileApplication);
            final Profile appliedProfile = delegate.getAppliedProfile(profileApplication);
            this.getProfilesToReapply(applyingPackage).add(appliedProfile);
            checkbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (checkbox.getSelection()) {
                        RefreshProfileDialog.this.getProfilesToReapply(applyingPackage).add(appliedProfile);
                    } else {
                        RefreshProfileDialog.this.getProfilesToReapply(applyingPackage).remove(appliedProfile);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.setEditor((Control)checkbox, treeItem, 4);
        }
        TreeItem[] treeItemArray = treeItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subitem = treeItemArray[n2];
            this.installEditors(subitem, currentDataItem);
            ++n2;
        }
    }

    protected IProfileApplicationDelegate getDelegate(ProfileApplication profileApplication) {
        return ProfileApplicationDelegateRegistry.INSTANCE.getDelegate(profileApplication);
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    protected Collection<Profile> getProfilesToReapply(Package currentPackage) {
        if (!this.profilesToReapply.containsKey(currentPackage)) {
            this.profilesToReapply.put(currentPackage, new LinkedHashSet());
        }
        return this.profilesToReapply.get(currentPackage);
    }

    protected void okPressed() {
        this.setSelectionResult(this.profilesToReapply.values().toArray());
        if (this.callback != null) {
            this.callback.run();
        }
        super.okPressed();
    }

    public Map<Package, Collection<Profile>> getProfilesToReapply() {
        return this.profilesToReapply;
    }
}

