/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.widgets.DynamicBodyEditor;
import org.eclipse.papyrus.uml.properties.widgets.ExpressionLanguageEditor;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ExpressionEditor
extends AbstractPropertyEditor
implements Listener,
ISelectionChangedListener,
ICommitListener {
    private final ExpressionLanguageEditor languageEditor;
    private IObservableList bodies;
    private ExpressionList.Expression currentExpression = null;
    private DynamicBodyEditor bodyEditor;
    ExpressionListChangeHandler expressionListChangeHandler;

    public ExpressionEditor(Composite parent, int style) {
        this.languageEditor = new ExpressionLanguageEditor(parent, 0);
        GridLayout l = new GridLayout(2, false);
        parent.setLayout((Layout)l);
        GridData gridData = new GridData(16384, 128, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.bodyEditor = new DynamicBodyEditor(parent, style);
        this.bodyEditor.setLayoutData(gridData);
        this.bodyEditor.addChangeListener(this);
        this.languageEditor.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.languageEditor.addCommitListener(this);
        this.expressionListChangeHandler = new ExpressionListChangeHandler();
        this.setEditor((AbstractListEditor)this.languageEditor);
    }

    public void setInput(DataSource input) {
        this.bodies = (IObservableList)input.getObservable("UML:OpaqueExpression:body");
        super.setInput(input);
    }

    protected void doBinding() {
        super.doBinding();
        this.languageEditor.addCommitListener((ExpressionList)this.observableList);
        this.bodyEditor.setContext(this.input.getModelElement(this.propertyPath));
        if (this.languageEditor.getViewer().getTree().getItemCount() > 0) {
            Object firstItem = this.languageEditor.getViewer().getTree().getItem(0).getData();
            StructuredSelection selection = new StructuredSelection(firstItem);
            this.languageEditor.getViewer().setSelection((ISelection)selection);
        }
    }

    protected IObservableList getInputObservableList() {
        if (this.observableList == null) {
            this.observableList = new ExpressionList(super.getInputObservableList(), this.bodies, this.expressionListChangeHandler);
        }
        return this.observableList;
    }

    public void handleEvent(Event event) {
        String newValue = this.bodyEditor.getValue();
        if (newValue == null) {
            return;
        }
        this.currentExpression.setBody(newValue);
        ((ExpressionList)this.observableList).commit((AbstractEditor)this.bodyEditor);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sSelection;
        ExpressionList.Expression newExpression;
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.bodyEditor.display(null);
        } else if (selection instanceof IStructuredSelection && (newExpression = (ExpressionList.Expression)((Object)(sSelection = (IStructuredSelection)selection).getFirstElement())) != this.currentExpression) {
            this.currentExpression = newExpression;
            this.bodyEditor.display(this.currentExpression);
        }
        this.bodyEditor.getParent().layout();
    }

    protected void applyReadOnly(boolean readOnly) {
        this.languageEditor.setReadOnly(readOnly);
        this.bodyEditor.setReadOnly(readOnly);
    }

    public void commit(AbstractEditor editor) {
        if (editor == this.languageEditor && this.observableList != null) {
            if (this.observableList.size() == 0) {
                this.languageEditor.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            } else if (this.observableList.size() == 1 || this.languageEditor.getViewer().getSelection().isEmpty()) {
                this.languageEditor.getViewer().setSelection((ISelection)new StructuredSelection(this.observableList.get(0)));
            }
        }
    }

    public class ExpressionListChangeHandler
    implements IChangeListener {
        public void handleChange(ChangeEvent event) {
            if (event.getSource() == ExpressionEditor.this.currentExpression) {
                ExpressionEditor.this.bodyEditor.display(ExpressionEditor.this.currentExpression);
            }
        }
    }
}

