/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.HistoryUtil;
import org.eclipse.papyrus.infra.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.creation.UMLPropertyEditorFactory;
import org.eclipse.papyrus.uml.properties.widgets.EStructuralFeatureEditor;
import org.eclipse.papyrus.uml.tools.providers.UMLContainerContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.providers.CreateInFeatureContentProvider;
import org.eclipse.papyrus.views.properties.providers.FeatureContentProvider;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.views.properties.widgets.layout.PropertiesLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GenericUMLDatatypeEditor
extends AbstractPropertyEditor {
    protected Composite self;

    public GenericUMLDatatypeEditor(Composite parent, int style) {
        this.self = new Composite(parent, 0);
        this.self.setLayout((Layout)new PropertiesLayout(false));
    }

    public void setProperty(String path) {
        this.propertyPath = path;
    }

    protected void checkInput() {
        if (this.input != null) {
            try {
                this.doBinding();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected void doBinding() {
        DataSource input = this.getInput();
        IStructuredSelection selection = input.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof EObject) {
            ILabelProvider labelProvider;
            EObject dataTypeInstance = (EObject)element;
            EClass dataTypeDefinition = dataTypeInstance.eClass();
            try {
                labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)dataTypeInstance)).getLabelProvider();
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                labelProvider = new UMLLabelProvider();
            }
            for (EStructuralFeature feature : dataTypeDefinition.getEAllStructuralFeatures()) {
                EStructuralFeatureEditor propertyEditor = new EStructuralFeatureEditor(this.self, 0);
                propertyEditor.setProviders((IStaticContentProvider)new UMLContentProvider(dataTypeInstance, feature), labelProvider);
                if (feature instanceof EReference) {
                    propertyEditor.setValueFactory((ReferenceValueFactory)this.getUMLPropertyEditorFactory(dataTypeInstance, (EReference)feature));
                }
                propertyEditor.setFeatureToEdit(feature.getName(), feature, dataTypeInstance);
            }
        }
    }

    protected UMLPropertyEditorFactory getUMLPropertyEditorFactory(EObject dataTypeInstance, EReference reference) {
        UMLPropertyEditorFactory factory = new UMLPropertyEditorFactory(reference);
        EClass type = reference.getEReferenceType();
        factory.setContainerLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
        factory.setReferenceLabelProvider((ILabelProvider)new EMFLabelProvider());
        UMLContainerContentProvider contentProvider = new UMLContainerContentProvider(dataTypeInstance, reference);
        EMFGraphicalContentProvider provider = ProviderHelper.encapsulateProvider((ITreeContentProvider)contentProvider, (ResourceSet)dataTypeInstance.eResource().getResourceSet(), (String)HistoryUtil.getHistoryID((EObject)dataTypeInstance, (EStructuralFeature)reference, (String)"container"));
        factory.setContainerContentProvider((IStaticContentProvider)provider);
        factory.setReferenceContentProvider((CreateInFeatureContentProvider)new FeatureContentProvider(type));
        return factory;
    }
}

