/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editparts.FloatingLabelEditPart;
import org.eclipse.papyrus.uml.properties.modelelement.UMLNotationModelElement;
import org.eclipse.papyrus.views.properties.modelelement.CompositeModelElement;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.providers.XWTCompliantMaskProvider;
import org.eclipse.papyrus.views.properties.providers.XWTCompliantMaskProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelCustomizationMaskProvider
implements XWTCompliantMaskProvider {
    private IMaskManagedLabelEditPolicy editPolicy;
    private DataSource input;
    private String propertyPath;
    private final Set<XWTCompliantMaskProviderListener> listeners = new HashSet<XWTCompliantMaskProviderListener>();

    public Map<String, String> getMasks() {
        return this.editPolicy.getMasks();
    }

    public void setProperty(String propertyPath) {
        this.propertyPath = propertyPath;
        this.checkInput();
    }

    public String getProperty() {
        return this.propertyPath;
    }

    public void setInput(DataSource input) {
        this.input = input;
        this.checkInput();
    }

    public DataSource getInput() {
        return this.input;
    }

    protected void checkInput() {
        if (this.input != null && this.propertyPath != null) {
            ModelElement element = this.input.getModelElement(this.propertyPath);
            if (element instanceof UMLNotationModelElement) {
                UMLNotationModelElement modelElement = (UMLNotationModelElement)element;
                this.editPolicy = (IMaskManagedLabelEditPolicy)modelElement.getEditPart().getEditPolicy((Object)"MaskManagedLabelPolicy");
                if (this.editPolicy != null) {
                    this.notifyListeners();
                }
            } else if (this.input.getSelection().getFirstElement() instanceof FloatingLabelEditPart) {
                EditPart editpart = (EditPart)this.input.getSelection().getFirstElement();
                this.editPolicy = (IMaskManagedLabelEditPolicy)editpart.getEditPolicy((Object)"INDRIRECT_MASK_MANAGED_LABEL");
                if (this.editPolicy != null) {
                    this.notifyListeners();
                }
            } else if (element instanceof CompositeModelElement) {
                this.editPolicy = null;
                IMaskManagedLabelEditPolicy currentEditPolicy = null;
                for (ModelElement subElement : ((CompositeModelElement)element).getSubElements()) {
                    if (!(subElement instanceof UMLNotationModelElement)) continue;
                    UMLNotationModelElement modelElement = (UMLNotationModelElement)subElement;
                    currentEditPolicy = (IMaskManagedLabelEditPolicy)modelElement.getEditPart().getEditPolicy((Object)"MaskManagedLabelPolicy");
                    if (currentEditPolicy == null) {
                        this.editPolicy = null;
                        break;
                    }
                    if (this.editPolicy != null && !this.editPolicy.getMasks().equals(currentEditPolicy.getMasks())) {
                        this.editPolicy = null;
                        break;
                    }
                    if (this.editPolicy != null) continue;
                    this.editPolicy = currentEditPolicy;
                }
                if (this.editPolicy != null) {
                    this.notifyListeners();
                }
            }
        }
    }

    private void notifyListeners() {
        for (XWTCompliantMaskProviderListener listener : this.listeners) {
            listener.notifyReady((XWTCompliantMaskProvider)this);
        }
    }

    public void addMaskProviderListener(XWTCompliantMaskProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeMaskProviderListener(XWTCompliantMaskProviderListener listener) {
        this.listeners.remove(listener);
    }
}

