/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattableFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.Style;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.modelelement.UMLNotationModelElement;
import org.eclipse.papyrus.views.properties.contexts.Property;
import org.eclipse.papyrus.views.properties.modelelement.CompositeModelElement;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.papyrus.views.properties.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.views.properties.modelelement.EMFModelElement;
import org.eclipse.papyrus.views.properties.modelelement.IDataSourceListener;
import org.eclipse.papyrus.views.properties.modelelement.ModelElement;
import org.eclipse.papyrus.views.properties.widgets.AbstractPropertyEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NattablePropertyEditor
extends AbstractPropertyEditor {
    protected Group self = null;
    private URI tableConfigURI = null;
    protected NatTable natTableWidget = null;
    protected INattableModelManager nattableManager = null;
    private DisposeListener nattableDisposeListener = null;
    private IDataSourceListener dataSourceListener;

    public NattablePropertyEditor(Composite parent, int style) {
        this.self = new Group(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        this.self.setLayout((Layout)fillLayout);
    }

    public void setTableURI(String uri) {
        this.tableConfigURI = URI.createURI((String)uri);
        this.checkInput();
    }

    public String getTableURI() {
        return this.tableConfigURI == null ? null : this.tableConfigURI.toString();
    }

    protected void checkInput() {
        if (this.tableConfigURI != null) {
            super.checkInput();
        }
    }

    protected void doBinding() {
        super.doBinding();
        ModelElement modelElement = this.input.getModelElement(this.propertyPath);
        ArrayList<EModelElement> rows = new ArrayList<EModelElement>();
        EObject sourceElement = null;
        EStructuralFeature feature = null;
        if (modelElement instanceof CompositeModelElement) {
            if (!((CompositeModelElement)modelElement).getSubElements().isEmpty()) {
                if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof UMLNotationModelElement) {
                    EModelElement eModelElement = ((UMLNotationModelElement)((Object)((CompositeModelElement)modelElement).getSubElements().get(0))).getEModelElement();
                    for (ModelElement subModelElement : ((CompositeModelElement)modelElement).getSubElements()) {
                        if (!(subModelElement instanceof UMLNotationModelElement)) continue;
                        rows.add(((UMLNotationModelElement)subModelElement).getEModelElement());
                    }
                    sourceElement = eModelElement;
                } else if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement) {
                    EMFModelElement emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                    sourceElement = emfModelElement.getSource();
                    feature = emfModelElement.getFeature(this.getLocalPropertyPath());
                }
            }
        } else if (modelElement instanceof UMLNotationModelElement) {
            EModelElement eModelElement = ((UMLNotationModelElement)modelElement).getEModelElement();
            rows.add(eModelElement);
            sourceElement = eModelElement;
        } else if (modelElement instanceof EMFModelElement) {
            EMFModelElement emfModelElement = (EMFModelElement)modelElement;
            sourceElement = emfModelElement.getSource();
            feature = emfModelElement.getFeature(this.getLocalPropertyPath());
        } else {
            this.displayError("Invalid table context");
            return;
        }
        this.createTableWidget(sourceElement, feature, rows);
    }

    protected void createTableWidget(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        Table table = this.createTable(sourceElement, feature, rows);
        if (table == null) {
            this.displayError("Cannot initialize the table");
            return;
        }
        this.nattableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.natTableWidget = this.nattableManager.createNattable((Composite)this.self, 0, null);
        if (this.nattableManager instanceof TreeNattableModelManager) {
            ((TreeNattableModelManager)this.nattableManager).doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, null);
        }
        this.self.addDisposeListener(this.getDisposeListener());
        this.natTableWidget.setBackground(this.self.getBackground());
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = this.natTableWidget.getPreferredHeight() - rows.size() * 70;
        this.self.setLayoutData((Object)data);
        this.natTableWidget.layout();
        this.self.layout();
    }

    protected void updateDescription(String description) {
        this.self.setToolTipText(description);
    }

    public void updateLabel(String label) {
        if (this.showLabel) {
            this.self.setText(this.getLabel());
        }
    }

    protected void displayError(String message) {
        Label label = new Label((Composite)this.self, 0);
        label.setText(message);
        label.setImage(org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage("icons/error.gif"));
    }

    protected Table createTable(EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows) {
        String description;
        TableConfiguration tableConfiguration = this.getTableConfiguration();
        if (tableConfiguration == null) {
            return null;
        }
        Property property = this.getModelProperty();
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(tableConfiguration);
        if (property != null && (description = property.getDescription()) != null) {
            table.setDescription(description);
        }
        table.setName(this.getLabel());
        Object rowProvider = tableConfiguration.getDefaultRowAxisProvider();
        rowProvider = rowProvider == null ? NattableaxisproviderFactory.eINSTANCE.createMasterObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        Object columnProvider = tableConfiguration.getDefaultColumnAxisProvider();
        columnProvider = columnProvider == null ? NattableaxisproviderFactory.eINSTANCE.createSlaveObjectAxisProvider() : (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        if (synchronizedFeature != null) {
            TableHeaderAxisConfiguration rowHeaderAxisconfig = tableConfiguration.getRowHeaderAxisConfiguration();
            for (Iterator axisConfig : rowHeaderAxisconfig.getOwnedAxisConfigurations()) {
                if (!(axisConfig instanceof EStructuralFeatureValueFillingConfiguration)) continue;
                ((EStructuralFeatureValueFillingConfiguration)axisConfig).setListenFeature(synchronizedFeature);
            }
        }
        table.setCurrentColumnAxisProvider(columnProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        table.setContext(sourceElement);
        for (Style style : tableConfiguration.getStyles()) {
            table.getStyles().add((Object)((Style)EcoreUtil.copy((EObject)style)));
        }
        if (TableHelper.isTreeTable((Table)table) && rows != null && !rows.isEmpty()) {
            AbstractAxisProvider axisProvider = table.getCurrentRowAxisProvider();
            TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration((Table)table);
            AxisManagerRepresentation rep = (AxisManagerRepresentation)conf.getAxisManagers().get(0);
            for (Object context : rows) {
                this.addTreeItemAxis(axisProvider, rep, context);
            }
        }
        return table;
    }

    protected void addTreeItemAxis(AbstractAxisProvider axisProvider, AxisManagerRepresentation rep, Object object) {
        if (object instanceof View && this.isStereotypedElement((View)object)) {
            ITreeItemAxis axis = ITreeItemAxisHelper.createITreeItemAxis(null, null, (Object)object, (AxisManagerRepresentation)rep);
            axisProvider.getAxis().add((Object)axis);
        }
    }

    protected boolean isStereotypedElement(View view) {
        boolean result = false;
        if (view.getElement() instanceof Element && !((Element)view.getElement()).getAppliedStereotypes().isEmpty()) {
            result = true;
        }
        return result;
    }

    protected TableConfiguration getTableConfiguration() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            TableConfiguration tableConfiguration = (TableConfiguration)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)this.tableConfigURI);
            return tableConfiguration;
        }
        catch (Exception ex) {
            Activator.log.error("Invalid table configuration", (Throwable)ex);
            return null;
        }
    }

    protected DisposeListener getDisposeListener() {
        if (this.nattableDisposeListener == null) {
            this.nattableDisposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    NattablePropertyEditor.this.nattableManager.dispose();
                    NattablePropertyEditor.this.natTableWidget.dispose();
                }
            };
        }
        return this.nattableDisposeListener;
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
    }

    protected void hookDataSourceListener(DataSource newInput) {
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                public void dataSourceChanged(DataSourceChangedEvent event) {
                    if (NattablePropertyEditor.this.nattableManager != null) {
                        NattablePropertyEditor.this.nattableManager.dispose();
                        NattablePropertyEditor.this.nattableManager = null;
                    }
                    if (NattablePropertyEditor.this.natTableWidget != null) {
                        NattablePropertyEditor.this.natTableWidget.dispose();
                        NattablePropertyEditor.this.natTableWidget = null;
                        NattablePropertyEditor.this.self.removeDisposeListener(NattablePropertyEditor.this.getDisposeListener());
                    }
                    DataSource dataSource = event.getDataSource();
                    StructuredSelection selection = (StructuredSelection)dataSource.getSelection();
                    ArrayList<Object> contexts = new ArrayList<Object>(selection.size());
                    for (Object selectedObject : selection) {
                        if (selectedObject instanceof AbstractEditPart) {
                            contexts.add(((AbstractEditPart)selectedObject).getModel());
                            continue;
                        }
                        contexts.add(selectedObject);
                    }
                    ModelElement modelElement = dataSource.getModelElement(NattablePropertyEditor.this.propertyPath);
                    EModelElement sourceElement = null;
                    EStructuralFeature feature = null;
                    if (modelElement instanceof CompositeModelElement) {
                        if (!((CompositeModelElement)modelElement).getSubElements().isEmpty()) {
                            if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof UMLNotationModelElement) {
                                sourceElement = ((UMLNotationModelElement)((Object)((CompositeModelElement)modelElement).getSubElements().get(0))).getEModelElement();
                            } else if (((CompositeModelElement)modelElement).getSubElements().get(0) instanceof EMFModelElement) {
                                EMFModelElement emfModelElement = (EMFModelElement)((CompositeModelElement)modelElement).getSubElements().get(0);
                                sourceElement = emfModelElement.getSource();
                                feature = emfModelElement.getFeature(NattablePropertyEditor.this.getLocalPropertyPath());
                            }
                        }
                    } else if (modelElement instanceof UMLNotationModelElement) {
                        sourceElement = ((UMLNotationModelElement)modelElement).getEModelElement();
                    } else if (modelElement instanceof EMFModelElement) {
                        EMFModelElement emfModelElement = (EMFModelElement)modelElement;
                        sourceElement = emfModelElement.getSource();
                        feature = emfModelElement.getFeature(NattablePropertyEditor.this.getLocalPropertyPath());
                    }
                    NattablePropertyEditor.this.createTableWidget((EObject)sourceElement, feature, contexts);
                }
            };
        }
        return this.dataSourceListener;
    }
}

