/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.papyrus.infra.emf.nattable.selection.EObjectSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.uml.properties.widgets.NattablePropertyEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypeDisplayNattablePropertyEditor
extends NattablePropertyEditor {
    public StereotypeDisplayNattablePropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createTableWidget(EObject sourceElement, EStructuralFeature feature, Collection<?> rows) {
        Table table = this.createTable(sourceElement, feature, rows);
        if (table == null) {
            this.displayError("Cannot initialize the table");
            return;
        }
        this.nattableManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, (ISelectionExtractor)new EObjectSelectionExtractor());
        this.natTableWidget = this.nattableManager.createNattable((Composite)this.self, 0, null);
        if (this.nattableManager instanceof TreeNattableModelManager) {
            if (rows != null && !rows.isEmpty()) {
                RowHideShowLayer layer = this.nattableManager.getBodyLayerStack().getRowHideShowLayer();
                int cpt = 0;
                while (cpt < rows.size()) {
                    this.natTableWidget.doCommand((ILayerCommand)new RowHideCommand((ILayer)layer, 0));
                    ++cpt;
                }
            }
            ((TreeNattableModelManager)this.nattableManager).doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, null);
        }
        this.self.addDisposeListener(this.getDisposeListener());
        this.natTableWidget.setBackground(this.self.getBackground());
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = this.natTableWidget.getPreferredHeight() - rows.size() * 70;
        this.self.setLayoutData((Object)data);
        this.natTableWidget.layout();
        this.self.layout();
    }
}

