/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtil {
    public static String IMAGE_PAPYRUS_EA = "image_papyrus";
    public static String IMAGE_EXPR_KEY = "image_expr_key";
    public static String IMAGE_KIND_KEY = "image_kind_key";
    public static String IMAGE_NAME_KEY = "image_name_key";

    public static void setContent(Image image, File imageFile) {
        try {
            String rawImageData = "";
            if (imageFile != null) {
                byte[] byteFlow = ImageUtil.getBytesFromFile(imageFile);
                rawImageData = "";
                byte[] byArray = byteFlow;
                int n = byteFlow.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    rawImageData = String.valueOf(rawImageData) + element + "%";
                    ++n2;
                }
            } else {
                rawImageData = null;
            }
            image.setContent(rawImageData);
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools.utils", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public static org.eclipse.swt.graphics.Image getContent(Image image) throws Exception {
        if (image == null) {
            return null;
        }
        if (image.getContent() == null) {
            return null;
        }
        String rawData = image.getContent();
        StringTokenizer strToken = new StringTokenizer(rawData, "%");
        byte[] target = new byte[strToken.countTokens()];
        int j = 0;
        while (strToken.hasMoreTokens()) {
            target[j] = new Byte(strToken.nextToken());
            ++j;
        }
        org.eclipse.swt.graphics.Image decodedImage = new org.eclipse.swt.graphics.Image(null, (InputStream)new ByteArrayInputStream(target));
        return decodedImage;
    }

    public static org.eclipse.swt.graphics.Image getImageFromLocation(Image image) {
        org.eclipse.swt.graphics.Image swtImage = null;
        String location = image.getLocation();
        if (location != null && !"".equals(location)) {
            URI iconURI = URI.createURI((String)location);
            if (iconURI.isRelative()) {
                String err_msg = "Incorrect implementation of relative location." + location;
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.uml.tools.utils", err_msg, (Throwable)new Exception(err_msg)));
                URI pluginURI = URI.createPlatformPluginURI((String)location, (boolean)true);
                iconURI = iconURI.resolve(pluginURI);
            }
            try {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(iconURI.toString()));
                swtImage = imageDescriptor.createImage();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.uml.tools.utils", "Could not create image from location : " + location, (Throwable)e));
            }
        }
        return swtImage;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            throw new IOException("Image too big to encode");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static void setExpression(Image image, String expression) {
        EAnnotation ea_Image = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (ea_Image == null) {
            ea_Image = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(expression)) {
            ea_Image.getDetails().removeKey((Object)IMAGE_EXPR_KEY);
        } else {
            ea_Image.getDetails().put((Object)IMAGE_EXPR_KEY, (Object)expression);
        }
        ImageUtil.cleanImageAnnotation(ea_Image);
    }

    public static String getExpression(Image image) {
        EAnnotation ea_ImageExpr = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String expr = null;
        if (ea_ImageExpr != null && ea_ImageExpr.getDetails().containsKey((Object)IMAGE_EXPR_KEY)) {
            expr = (String)ea_ImageExpr.getDetails().get((Object)IMAGE_EXPR_KEY);
        }
        return expr;
    }

    public static void setName(Image image, String name) {
        EAnnotation ea_Image = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (ea_Image == null) {
            ea_Image = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(name)) {
            ea_Image.getDetails().removeKey((Object)IMAGE_NAME_KEY);
        } else {
            ea_Image.getDetails().put((Object)IMAGE_NAME_KEY, (Object)name);
        }
        ImageUtil.cleanImageAnnotation(ea_Image);
    }

    public static String getName(Image image) {
        EAnnotation ea_Image = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String name = null;
        if (ea_Image != null && ea_Image.getDetails().containsKey((Object)IMAGE_NAME_KEY)) {
            name = (String)ea_Image.getDetails().get((Object)IMAGE_NAME_KEY);
        }
        return name;
    }

    private static void cleanImageAnnotation(EAnnotation annotation) {
        EMap details = annotation.getDetails();
        if (details.isEmpty()) {
            annotation.setEModelElement(null);
        }
    }

    public static void setKind(Image image, String kind) {
        EAnnotation ea_Image = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        if (ea_Image == null) {
            ea_Image = image.createEAnnotation(IMAGE_PAPYRUS_EA);
        }
        if ("".equals(kind)) {
            ea_Image.getDetails().removeKey((Object)IMAGE_KIND_KEY);
        } else {
            ea_Image.getDetails().put((Object)IMAGE_KIND_KEY, (Object)kind);
        }
        ImageUtil.cleanImageAnnotation(ea_Image);
    }

    public static String getKind(Image image) {
        EAnnotation ea_ImageExpr = image.getEAnnotation(IMAGE_PAPYRUS_EA);
        String kind = null;
        if (ea_ImageExpr != null && ea_ImageExpr.getDetails().containsKey((Object)IMAGE_KIND_KEY)) {
            kind = (String)ea_ImageExpr.getDetails().get((Object)IMAGE_KIND_KEY);
        }
        return kind;
    }

    public static boolean evalExpression(Image image, Element element) {
        Object val;
        String propName = null;
        String literal = null;
        Stereotype st = (Stereotype)image.getOwner();
        String expression = ImageUtil.getExpression(image);
        if (expression == null) {
            return false;
        }
        StringTokenizer sToken = new StringTokenizer(expression.replace(" ", ""), "=");
        if (sToken.countTokens() != 2) {
            return false;
        }
        propName = sToken.nextToken();
        literal = sToken.nextToken();
        return element.getValue(st, propName) != null && ((val = element.getValue(st, propName)) instanceof EnumerationLiteral ? ((EnumerationLiteral)val).getLabel().equals(literal) : val instanceof Enumerator && ((Enumerator)val).getName().equals(literal));
    }

    public static Image findImageVerifyingExpression(Element element, EList<Image> images) {
        Image image = null;
        Iterator it = images.iterator();
        while (image == null && it.hasNext()) {
            Image current = (Image)it.next();
            if (!ImageUtil.evalExpression(current, element)) continue;
            image = current;
        }
        return image;
    }

    public static String getImageId(Image image) {
        String id = "";
        Stereotype owner = (Stereotype)image.getOwner();
        id = String.valueOf(id) + owner.getQualifiedName() + "_img_" + owner.getIcons().indexOf((Object)image);
        return id;
    }
}

