/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.uml.tools";
    public static final String TRACE_LANGUAGE_PROVIDERS = "providers/language";
    private static Activator plugin;
    public static LogHelper log;
    private ComposedAdapterFactory adapterFactory;
    private static final String UML_ICONS = "/org.eclipse.uml2.uml.edit/icons/full/obj16/";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        log = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        return new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    public AdapterFactory getItemProviderAdapterFactory() {
        return this.adapterFactory;
    }

    @Deprecated
    public Image getImageForUMLMetaclass(EClass eClass) {
        return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImageFromPlugin(UML_ICONS + eClass.getName() + ".gif");
    }

    @Deprecated
    public Image getIconElement(Element element) {
        EList stereotypeList = element.getAppliedStereotypes();
        if (stereotypeList == null || stereotypeList.isEmpty()) {
            return null;
        }
        return Activator.getIconElement(element, (Stereotype)stereotypeList.get(0));
    }

    @Deprecated
    public Collection<Image> getIconElements(Element elt, Collection<Stereotype> stereotypes) {
        ArrayList<Image> images = new ArrayList<Image>();
        for (Stereotype stereotype : stereotypes) {
            org.eclipse.uml2.uml.Image icon = ElementUtil.getStereotypeImage((Element)elt, (Stereotype)stereotype, (String)"icon");
            if (icon == null) continue;
            images.add(Activator.getImageInRegistry(icon));
        }
        return images;
    }

    @Deprecated
    public static Image getIconElement(Element elt, Stereotype stereotype) {
        org.eclipse.uml2.uml.Image icon = ElementUtil.getStereotypeImage((Element)elt, (Stereotype)stereotype, (String)"icon");
        if (icon != null) {
            return Activator.getImageInRegistry(icon);
        }
        return null;
    }

    @Deprecated
    public static Image getImageInRegistry(org.eclipse.uml2.uml.Image umlImage) {
        String image_id;
        ImageRegistry papyrusRegistry = Activator.getDefault().getImageRegistry();
        Image image = papyrusRegistry.get(image_id = ImageUtil.getImageId((org.eclipse.uml2.uml.Image)umlImage));
        if (image == null) {
            try {
                image = ImageUtil.getContent((org.eclipse.uml2.uml.Image)umlImage);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image == null) {
                image = ImageUtil.getImageFromLocation((org.eclipse.uml2.uml.Image)umlImage);
            }
            if (image != null) {
                ImageData imdata = image.getImageData();
                papyrusRegistry.put(image_id, ImageDescriptor.createFromImageData((ImageData)imdata));
                image = papyrusRegistry.get(image_id);
            }
        }
        return image;
    }
}

