/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.commands.SetMultiplicityCommand;
import org.eclipse.papyrus.uml.tools.databinding.AggregatedPapyrusObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.uml.tools.helper.UMLDatabindingHelper;
import org.eclipse.papyrus.uml.tools.util.MultiplicityParser;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;

public class MultiplicityObservableValue
extends ReferenceCountedObservable.Value
implements IChangeListener,
CommandBasedObservableValue,
AggregatedObservable,
IObserving {
    private IObservableValue lowerBound;
    private IObservableValue upperBound;
    private IObservableValue lowerValue;
    private IObservableValue upperValue;
    private IObservableValue lowerValueSpecification;
    private IObservableValue upperValueSpecification;
    private EStructuralFeature lowerFeature;
    private EStructuralFeature upperFeature;
    private EObject eObject;
    private EditingDomain domain;

    public MultiplicityObservableValue(EObject eObject, EditingDomain domain) {
        this.eObject = eObject;
        this.domain = domain;
        this.lowerFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Lower();
        this.upperFeature = UMLPackage.eINSTANCE.getMultiplicityElement_Upper();
        EReference lowerValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue();
        EReference upperValueFeature = UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue();
        EAttribute lowerValueSpecificationFeature = UMLPackage.eINSTANCE.getLiteralInteger_Value();
        EAttribute upperValueSpecificationFeature = UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value();
        this.lowerBound = UMLDatabindingHelper.getObservableValue(eObject, this.lowerFeature, domain);
        this.upperBound = UMLDatabindingHelper.getObservableValue(eObject, this.upperFeature, domain);
        this.lowerValue = UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)lowerValueFeature, domain);
        this.upperValue = UMLDatabindingHelper.getObservableValue(eObject, (EStructuralFeature)upperValueFeature, domain);
        this.lowerValueSpecification = this.getValueSpecification(this.lowerValue, (EStructuralFeature)lowerValueSpecificationFeature, domain);
        this.upperValueSpecification = this.getValueSpecification(this.upperValue, (EStructuralFeature)upperValueSpecificationFeature, domain);
        this.lowerValue.addChangeListener((IChangeListener)this);
        this.upperValue.addChangeListener((IChangeListener)this);
        if (this.lowerValueSpecification != null) {
            this.lowerValueSpecification.addChangeListener((IChangeListener)this);
        }
        if (this.upperValueSpecification != null) {
            this.upperValueSpecification.addChangeListener((IChangeListener)this);
        }
    }

    private IObservableValue getValueSpecification(IObservableValue source, EStructuralFeature specificationFeature, EditingDomain domain) {
        if (source.getValue() == null) {
            return null;
        }
        return UMLDatabindingHelper.getObservableValue((EObject)source.getValue(), specificationFeature, domain);
    }

    public void handleChange(ChangeEvent event) {
        boolean fireChange = false;
        if (event.getSource() == this.lowerValue || event.getSource() == this.upperValue) {
            fireChange = true;
            this.lowerValueSpecification = this.getValueSpecification(this.lowerValue, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralInteger_Value(), this.domain);
            this.upperValueSpecification = this.getValueSpecification(this.upperValue, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value(), this.domain);
        }
        if (event.getSource() == this.lowerValueSpecification || event.getSource() == this.upperValueSpecification) {
            fireChange = true;
        }
        if (fireChange) {
            final Object value = this.getValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return null;
                }

                public Object getNewValue() {
                    return value;
                }
            });
        }
    }

    public Object getObserved() {
        return this.eObject;
    }

    public synchronized void dispose() {
        this.lowerValue.removeChangeListener((IChangeListener)this);
        this.upperValue.removeChangeListener((IChangeListener)this);
        if (this.lowerValueSpecification != null) {
            this.lowerValueSpecification.removeChangeListener((IChangeListener)this);
            this.lowerValueSpecification.dispose();
        }
        if (this.upperValueSpecification != null) {
            this.upperValueSpecification.removeChangeListener((IChangeListener)this);
            this.upperValueSpecification.dispose();
        }
        this.lowerValue.dispose();
        this.upperValue.dispose();
        this.lowerBound.dispose();
        this.upperBound.dispose();
        super.dispose();
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        String result = null;
        if (this.eObject instanceof MultiplicityElement) {
            result = MultiplicityElementUtil.formatMultiplicityNoBrackets((MultiplicityElement)((MultiplicityElement)this.eObject));
        } else {
            int lower = 0;
            int upper = 0;
            Object lowerValue = this.lowerBound.getValue();
            Object upperValue = this.upperBound.getValue();
            lower = (Integer)lowerValue;
            upper = (Integer)upperValue;
            result = MultiplicityParser.getMultiplicity(lower, upper);
        }
        return result;
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    @Override
    public Command getCommand(Object value) {
        String val = (String)value;
        int[] lowerUpper = MultiplicityParser.getBounds(val);
        if (lowerUpper == null || lowerUpper.length < 2) {
            return UnexecutableCommand.INSTANCE;
        }
        int lower = lowerUpper[0];
        int upper = lowerUpper[1];
        if (MultiplicityParser.isValidMultiplicity(lower, upper)) {
            try {
                return new SetMultiplicityCommand((MultiplicityElement)this.eObject, val);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    public AggregatedObservable aggregate(IObservable observable) {
        try {
            return new AggregatedPapyrusObservableValue(this.domain, this, observable);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public boolean hasDifferentValues() {
        return false;
    }
}

