/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.providers.EMFEnumeratorContentProvider;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.widgets.providers.EmptyContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.providers.InstanceValueContentProvider;
import org.eclipse.papyrus.uml.tools.providers.InteractionOperatorContentProvider;
import org.eclipse.papyrus.uml.tools.providers.PortInterfaceContentProvider;
import org.eclipse.papyrus.uml.tools.providers.SemanticUMLContentProvider;
import org.eclipse.papyrus.uml.tools.providers.ServiceEditFilteredContentProvider;
import org.eclipse.papyrus.uml.tools.util.UMLProviderHelper;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLContentProvider
extends EncapsulatedContentProvider {
    protected EObject eObject;
    protected EStructuralFeature feature;
    protected Stereotype stereotype;
    protected ResourceSet root;

    public UMLContentProvider() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IStructuredContentProvider semanticProvider = null;
        if (newInput instanceof EObject) {
            EObject eObject = (EObject)newInput;
            semanticProvider = this.getSemanticProvider(eObject);
        }
        if (newInput instanceof Resource) {
            semanticProvider = this.getSemanticProvider((Resource)newInput);
        }
        if (newInput instanceof ResourceSet) {
            this.root = (ResourceSet)newInput;
            semanticProvider = this.getSemanticProvider(this.root);
        }
        if (newInput instanceof ServicesRegistry) {
            try {
                this.root = ServiceUtils.getInstance().getModelSet((Object)((ServicesRegistry)newInput));
                semanticProvider = this.getSemanticProvider(this.root);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (semanticProvider != null) {
            this.encapsulated = UMLProviderHelper.encapsulateProvider(semanticProvider, null, this.feature, this.root);
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public UMLContentProvider(EObject source, EStructuralFeature feature) {
        this(source, feature, null);
    }

    public UMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype) {
        this(source, feature, stereotype, null);
    }

    public UMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype, ResourceSet root) {
        this.eObject = source;
        this.feature = feature;
        this.stereotype = stereotype;
        if (root == null && this.eObject.eResource() != null) {
            try {
                root = (ResourceSet)ServiceUtilsForResource.getInstance().getService(ResourceSet.class, (Object)this.eObject.eResource());
            }
            catch (ServiceException e) {
                root = this.eObject.eResource().getResourceSet();
            }
        }
        if (root == null) {
            try {
                root = (ResourceSet)ServiceUtilsForActionHandlers.getInstance().getServiceRegistry().getService(ResourceSet.class);
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
        this.root = root;
        IStructuredContentProvider semanticProvider = this.getSemanticProvider(source, feature, stereotype);
        this.encapsulated = UMLProviderHelper.encapsulateProvider(semanticProvider, this.eObject, feature, root);
    }

    protected IStructuredContentProvider getSemanticProvider(ResourceSet root) {
        return new SemanticUMLContentProvider(root);
    }

    protected IStructuredContentProvider getSemanticProvider(Resource root) {
        return new SemanticUMLContentProvider((EObject[])root.getContents().toArray((Object[])new EObject[0]));
    }

    protected IStructuredContentProvider getSemanticProvider(EObject root) {
        return new SemanticUMLContentProvider(new EObject[]{root});
    }

    protected IStructuredContentProvider getSemanticProvider(EObject source, EStructuralFeature feature, Stereotype stereotype) {
        if (feature == null) {
            return EmptyContentProvider.instance;
        }
        if (UMLUtil.getBaseElement((EObject)source) != null) {
            if (feature.getEType() instanceof EClass) {
                return this.getStereotypedReferenceContentProvider(source, feature, (EClass)feature.getEType());
            }
        } else {
            EObject sourceCont = source.eContainer();
            if (sourceCont != null && UMLUtil.getBaseElement((EObject)sourceCont) != null && feature.getEType() instanceof EClass) {
                return this.getStereotypedReferenceContentProvider(sourceCont, source, feature, (EClass)feature.getEType());
            }
        }
        if (feature == UMLPackage.eINSTANCE.getCombinedFragment_InteractionOperator()) {
            return new InteractionOperatorContentProvider(source, feature);
        }
        if (feature.getEType() instanceof EEnum) {
            return new EMFEnumeratorContentProvider(feature);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided() || feature == UMLPackage.eINSTANCE.getPort_Required()) {
            return new PortInterfaceContentProvider(source, feature);
        }
        if (feature == UMLPackage.eINSTANCE.getInstanceValue_Instance()) {
            return new InstanceValueContentProvider((InstanceValue)source, feature, this.root);
        }
        return new ServiceEditFilteredContentProvider(source, feature, this.root);
    }

    protected IHierarchicContentProvider getStereotypedReferenceContentProvider(EObject source, EStructuralFeature feature, Stereotype type) {
        ResourceSet root = UMLUtil.getBaseElement((EObject)source).eResource().getResourceSet();
        ServiceEditFilteredContentProvider contentProvider = new ServiceEditFilteredContentProvider(source, feature, root);
        contentProvider.setWantedMetaclasses(Collections.singletonList(type));
        return contentProvider;
    }

    protected IHierarchicContentProvider getStereotypedReferenceContentProvider(EObject source, EStructuralFeature feature, EClass type) {
        return this.getStereotypedReferenceContentProvider(source, source, feature, type);
    }

    protected IHierarchicContentProvider getStereotypedReferenceContentProvider(EObject source, EObject subSource, EStructuralFeature feature, EClass type) {
        ResourceSet root = UMLUtil.getBaseElement((EObject)source).eResource().getResourceSet();
        ServiceEditFilteredContentProvider contentProvider = new ServiceEditFilteredContentProvider(subSource, feature, root);
        contentProvider.setWantedMetaclasses(Collections.singletonList(type));
        return contentProvider;
    }
}

