/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.namereferences.NameReferencesHelper;
import org.eclipse.papyrus.uml.tools.providers.DelegatingItemLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationTemplateParameter;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLLabelProvider
extends EMFLabelProvider
implements ILabelProvider {
    public static final String ICON_METACLASS = "/icons/Metaclass.gif";
    private IItemLabelProvider labelProvider = new DelegatingItemLabelProvider(3);

    protected Image getImage(EObject element) {
        if ((element = this.resolveElement(element)) instanceof Element) {
            Image image = Activator.getDefault().getIconElement((Element)element);
            return image == null ? super.getImage(element) : image;
        }
        return super.getImage(element);
    }

    protected EObject resolveElement(EObject inputElement) {
        if (inputElement == null) {
            return null;
        }
        if (inputElement instanceof Element) {
            return inputElement;
        }
        Element baseElement = UMLUtil.getBaseElement((EObject)inputElement);
        if (baseElement != null) {
            return baseElement;
        }
        return inputElement;
    }

    public String getText(Object element) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof Comment) {
            return this.getText(eObject);
        }
        if (!(eObject instanceof Element) && UMLUtil.getBaseElement((EObject)eObject) instanceof Comment) {
            return this.getText(eObject);
        }
        if (eObject instanceof Property) {
            return this.getText((Property)eObject);
        }
        return super.getText(element);
    }

    protected String getText(Property property) {
        String multiplicityAsString;
        String typeLabel;
        String typeName;
        String label;
        StringBuffer text = new StringBuffer();
        Type type = property.getType();
        if (property.isDerived()) {
            this.appendString(text, "/");
        }
        if (!UML2Util.isEmpty((String)(label = property.getLabel(this.shouldTranslate())))) {
            this.appendString(text, label);
        } else if (property.getAssociation() != null && type != null && !UML2Util.isEmpty((String)(typeName = type.getName()))) {
            if (property instanceof ExtensionEnd) {
                this.appendString(text, "extension_" + typeName);
            } else {
                this.appendString(text, String.valueOf(Character.toLowerCase(typeName.charAt(0))) + typeName.substring(1));
            }
        }
        if (type != null && !UMLUtil.isEmpty((String)(typeLabel = type.getLabel(this.shouldTranslate())))) {
            this.appendString(text, ": " + typeLabel);
        }
        if ((property.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER) || property.eIsSet((EStructuralFeature)UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER)) && !(multiplicityAsString = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property)).isEmpty()) {
            text.append(multiplicityAsString);
        }
        return text.toString();
    }

    protected StringBuffer appendString(StringBuffer text, String string) {
        if (!UML2Util.isEmpty((String)string)) {
            if (text.length() > 0) {
                text.append(' ');
            }
            text.append(string);
        }
        return text;
    }

    protected StringBuffer appendKeywords(StringBuffer text, Property property) {
        Iterator appliedStereotypes = property.getAppliedStereotypes().iterator();
        Iterator keywords = property.getKeywords().iterator();
        if (appliedStereotypes.hasNext() || keywords.hasNext()) {
            if (text.length() > 0) {
                text.append(' ');
            }
            text.append("<<");
            while (appliedStereotypes.hasNext()) {
                text.append(((Stereotype)appliedStereotypes.next()).getKeyword(this.shouldTranslate()));
                if (!appliedStereotypes.hasNext() && !keywords.hasNext()) continue;
                text.append(", ");
            }
            while (keywords.hasNext()) {
                text.append((String)keywords.next());
                if (!keywords.hasNext()) continue;
                text.append(", ");
            }
            text.append(">>");
        }
        return text;
    }

    protected boolean shouldTranslate() {
        return UMLEditPlugin.INSTANCE.shouldTranslate();
    }

    protected String getText(EObject element) {
        if ((element = this.resolveElement(element)) == null) {
            return "<Undefined>";
        }
        if (element instanceof org.eclipse.uml2.uml.Image) {
            org.eclipse.uml2.uml.Image image = (org.eclipse.uml2.uml.Image)element;
            String imageName = ImageUtil.getName((org.eclipse.uml2.uml.Image)image);
            String location = image.getLocation();
            if (this.isEmptyString(imageName)) {
                if (this.isEmptyString(location)) {
                    return "Image";
                }
                return location;
            }
            if (this.isEmptyString(location)) {
                return imageName;
            }
            return String.valueOf(imageName) + " : " + location;
        }
        if (element instanceof PackageImport) {
            return this.labelProvider.getText((Object)element);
        }
        if (element instanceof ElementImport) {
            return this.labelProvider.getText((Object)element);
        }
        if (element instanceof PackageMerge) {
            return this.labelProvider.getText((Object)element);
        }
        if (element instanceof NamedElement) {
            if (element instanceof ValueSpecification) {
                String value = null;
                if (element instanceof InstanceValue) {
                    InstanceSpecification specification = ((InstanceValue)element).getInstance();
                    if (specification != null) {
                        value = this.getText((EObject)specification);
                    }
                } else {
                    value = element instanceof LiteralString ? "\"" + ((ValueSpecification)element).stringValue() + "\"" : (element instanceof LiteralNull ? "null" : ((ValueSpecification)element).stringValue());
                }
                if (value != null) {
                    if (((NamedElement)element).isSetName() && ((NamedElement)element).getName() != null) {
                        return String.valueOf(((NamedElement)element).getName()) + "=" + value;
                    }
                    return value;
                }
                if (((NamedElement)element).isSetName() && ((NamedElement)element).getName() != null) {
                    return ((NamedElement)element).getName();
                }
                return "";
            }
            return this.labelProvider.getText((Object)element);
        }
        if (element instanceof Comment) {
            Comment comment = (Comment)element;
            return this.getText(comment);
        }
        if (element instanceof PackageMerge) {
            return this.labelProvider.getText((Object)element);
        }
        if (element instanceof TemplateParameter) {
            TemplateParameter templateParam = (TemplateParameter)element;
            if (templateParam.getParameteredElement() == null) {
                return "<UNDEFINED>";
            }
            String out = "";
            if (templateParam.getParameteredElement() instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)templateParam.getParameteredElement();
                out = String.valueOf(namedElement.getName()) + ": " + namedElement.eClass().getName();
            }
            if (templateParam instanceof OperationTemplateParameter) {
                if (templateParam.getParameteredElement() != null) {
                    Operation op = (Operation)templateParam.getParameteredElement();
                    out = this.displayOperation(op);
                }
            } else if (templateParam instanceof ClassifierTemplateParameter && !((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().isEmpty()) {
                out = String.valueOf(out) + ">";
                int i = 0;
                while (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size()) {
                    out = String.valueOf(out) + ((Classifier)((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().get(i)).getName();
                    if (i < ((ClassifierTemplateParameter)templateParam).getConstrainingClassifiers().size() - 1) {
                        out = String.valueOf(out) + ", ";
                    }
                    ++i;
                }
            }
            if (templateParam.getDefault() instanceof Operation) {
                out = String.valueOf(out) + "=" + this.displayOperation((Operation)templateParam.getDefault());
            } else if (templateParam.getDefault() instanceof NamedElement) {
                out = String.valueOf(out) + "=" + ((NamedElement)templateParam.getDefault()).getName();
            }
            return out;
        }
        if (element instanceof TemplateParameterSubstitution) {
            String out = "";
            TemplateParameterSubstitution substitution = (TemplateParameterSubstitution)element;
            if (substitution.getFormal() != null && substitution.getFormal().getParameteredElement() instanceof NamedElement) {
                out = String.valueOf(out) + ((NamedElement)substitution.getFormal().getParameteredElement()).getName();
            }
            if (substitution.getActual() instanceof NamedElement) {
                out = String.valueOf(out) + " -> " + ((NamedElement)substitution.getActual()).getName() + "\n";
            }
            return out;
        }
        if (element instanceof Element) {
            return this.labelProvider.getText((Object)element);
        }
        return super.getText(element);
    }

    protected String getText(Comment comment) {
        String truncatedText;
        String singleLineText;
        NameReferencesHelper helper = new NameReferencesHelper(comment.eResource()){

            @Override
            protected String decorate(String text) {
                return text;
            }
        };
        String body = comment.getBody();
        if (body == null) {
            return "<Empty Comment>";
        }
        int nIndex = body.indexOf(10);
        int rIndex = body.indexOf(13);
        int minIndex = -1;
        if (nIndex > -1) {
            minIndex = rIndex > -1 ? Math.min(nIndex, rIndex) : nIndex;
        } else if (rIndex > -1) {
            minIndex = rIndex;
        }
        boolean isTruncated = false;
        if (minIndex > -1) {
            singleLineText = body.substring(0, minIndex);
            isTruncated = true;
        } else {
            singleLineText = body;
        }
        singleLineText = helper.replaceReferences(singleLineText);
        int maxLength = 60;
        if (singleLineText.length() > maxLength) {
            truncatedText = singleLineText.substring(0, maxLength);
            isTruncated = true;
        } else {
            truncatedText = singleLineText;
        }
        if (isTruncated) {
            truncatedText = String.valueOf(truncatedText) + "...";
        }
        return truncatedText;
    }

    private boolean isEmptyString(String s) {
        return s == null || s.trim().equals("");
    }

    protected String displayOperation(Operation op) {
        String out = String.valueOf(op.getName()) + "(";
        for (Parameter param : op.getOwnedParameters()) {
            out = String.valueOf(out) + param.getName();
            if (param.equals(op.getOwnedParameters().get(op.getOwnedParameters().size() - 1))) continue;
            out = String.valueOf(out) + ", ";
        }
        out = String.valueOf(out) + ")";
        return out;
    }

    protected EObject getParent(EObject object) {
        return object instanceof Element ? ((Element)object).getOwner() : super.getParent(object);
    }

    protected String getQualifiedText(EObject object) {
        return object instanceof NamedElement ? ((NamedElement)object).getQualifiedName() : super.getQualifiedText(object);
    }
}

