/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.xtext.integration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.extensionpoints.Registry;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class InvalidStringUtil {
    public static final String TEXTUAL_REPRESENTATION = "TextualRepresentation";
    public static final String LANGUAGE = "language";
    public static String ACTION_LANGUAGE_PROFILE_NAME = "ActionLanguage";
    protected static Profile actionLanguageProfile;
    protected static Stereotype textualRepresentationStereotype;

    public static String getTextualRepresentation(Element element) {
        Comment textualRepresentationComment = InvalidStringUtil.getTextualRepresentationComment(element);
        if (textualRepresentationComment == null) {
            return null;
        }
        return textualRepresentationComment.getBody();
    }

    public static Comment getTextualRepresentationComment(Element element) {
        Comment textualRepresentationComment = null;
        for (Comment comment : element.getOwnedComments()) {
            if (comment.getBody() == null || !InvalidStringUtil.isATextualRepresentationComment(comment)) continue;
            textualRepresentationComment = comment;
        }
        return textualRepresentationComment;
    }

    public static boolean isATextualRepresentationComment(Comment comment) {
        if (textualRepresentationStereotype != null) {
            return comment.getAppliedStereotypes().contains((Object)textualRepresentationStereotype);
        }
        EList applicableStereotypes = comment.getApplicableStereotypes();
        int i = 0;
        while (i < applicableStereotypes.size() && textualRepresentationStereotype == null) {
            if (((Stereotype)applicableStereotypes.get(i)).getName().equals(TEXTUAL_REPRESENTATION)) {
                textualRepresentationStereotype = (Stereotype)applicableStereotypes.get(i);
            }
            ++i;
        }
        return textualRepresentationStereotype != null;
    }

    public static boolean isActionLanguageProfileApplied(Element element) {
        if (actionLanguageProfile == null) {
            IRegisteredProfile registeredActionLanguageProfile = Registry.getRegisteredProfile((String)ACTION_LANGUAGE_PROFILE_NAME, null);
            URI modelUri = registeredActionLanguageProfile.getUri();
            Package root = PackageUtil.getRootPackage((Element)element);
            Resource modelResource = root.eResource().getResourceSet().getResource(modelUri, true);
            if (modelResource.getContents().get(0) instanceof Profile) {
                actionLanguageProfile = (Profile)modelResource.getContents().get(0);
            }
        }
        EList appliedProfiles = PackageUtil.getRootPackage((Element)element).getAppliedProfiles();
        return appliedProfiles.contains(actionLanguageProfile);
    }

    public static Comment createTextualRepresentationComment(Element element, String languageId) {
        Comment textualRepresentationComment = element.createOwnedComment();
        if (!InvalidStringUtil.isActionLanguageProfileApplied(element)) {
            PackageUtil.applyProfile((Package)PackageUtil.getRootPackage((Element)element), (Profile)actionLanguageProfile, (boolean)true);
        }
        InvalidStringUtil.clean();
        InvalidStringUtil.isATextualRepresentationComment(textualRepresentationComment);
        textualRepresentationComment.applyStereotype(textualRepresentationStereotype);
        textualRepresentationComment.setValue(textualRepresentationStereotype, LANGUAGE, (Object)languageId);
        return textualRepresentationComment;
    }

    public static void clean() {
        actionLanguageProfile = null;
        textualRepresentationStereotype = null;
    }
}

