/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandHandler
extends AbstractModelExplorerHandler {
    private List<?> selection = Collections.EMPTY_LIST;

    protected abstract Command getCommand();

    protected List<?> getSelection() {
        return this.selection;
    }

    protected EObject getSelectedElement() {
        Object first;
        EObject businessObject;
        EObject eObject = null;
        List<?> selection = this.getSelection();
        if (!selection.isEmpty() && (businessObject = EMFHelper.getEObject(first = selection.get(0))) != null) {
            eObject = businessObject;
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        List<?> selection = this.getSelection();
        if (!selection.isEmpty()) {
            for (Object current : selection) {
                EObject selectedEObject = EMFHelper.getEObject(current);
                if (selectedEObject == null) continue;
                selectedEObjects.add(selectedEObject);
            }
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            try {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                this.selection = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.EMPTY_LIST;
                ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event).getCommandStack().execute(this.getCommand());
            }
            catch (ServiceException e) {
                Activator.log.error("Unexpected error while executing command.", (Throwable)e);
                this.selection = Collections.EMPTY_LIST;
            }
        }
        finally {
            this.selection = Collections.EMPTY_LIST;
        }
        return null;
    }

    protected boolean computeEnabled() {
        boolean result = false;
        Command command = this.getCommand();
        if (command != null) {
            result = this.getCommand().canExecute();
            command.dispose();
        }
        return result;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection;
        if (evaluationContext instanceof IEvaluationContext && (selection = ((IEvaluationContext)evaluationContext).getDefaultVariable()) instanceof Collection) {
            this.selection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
            this.setBaseEnabled(this.computeEnabled());
            this.selection = Collections.EMPTY_LIST;
        }
        super.setEnabled(evaluationContext);
    }
}

