/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.contexts.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EModelElementItemProvider;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.views.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.views.properties.environment.provider.PropertiesEditPlugin;

public class ContextItemProvider
extends EModelElementItemProvider {
    public ContextItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addDependenciesPropertyDescriptor(object);
            this.addPrototypePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Context_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Context_name_feature", "_UI_Context_type"), (EStructuralFeature)ContextsPackage.Literals.CONTEXT__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDependenciesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Context_dependencies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Context_dependencies_feature", "_UI_Context_type"), (EStructuralFeature)ContextsPackage.Literals.CONTEXT__DEPENDENCIES, true, false, true, null, null, null));
    }

    protected void addPrototypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Context_prototype_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Context_prototype_feature", "_UI_Context_type"), (EStructuralFeature)ContextsPackage.Literals.CONTEXT__PROTOTYPE, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ContextsPackage.Literals.CONTEXT__TABS);
            this.childrenFeatures.add(ContextsPackage.Literals.CONTEXT__VIEWS);
            this.childrenFeatures.add(ContextsPackage.Literals.CONTEXT__DATA_CONTEXTS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Context"));
    }

    public String getText(Object object) {
        String label = ((Context)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_Context_type") : String.valueOf(this.getString("_UI_Context_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Context.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ContextsPackage.Literals.CONTEXT__TABS, ContextsFactory.eINSTANCE.createTab()));
        newChildDescriptors.add(this.createChildParameter(ContextsPackage.Literals.CONTEXT__VIEWS, ContextsFactory.eINSTANCE.createView()));
        newChildDescriptors.add(this.createChildParameter(ContextsPackage.Literals.CONTEXT__DATA_CONTEXTS, ContextsFactory.eINSTANCE.createDataContextRoot()));
    }

    public ResourceLocator getResourceLocator() {
        return PropertiesEditPlugin.INSTANCE;
    }
}

