/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.environment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    STRING(0, "String", "String"),
    BOOLEAN(1, "Boolean", "Boolean"),
    INTEGER(2, "Integer", "Integer"),
    REFERENCE(3, "Reference", "Reference"),
    ENUMERATION(4, "Enumeration", "Enumeration"),
    DOUBLE(5, "Double", "Double");

    public static final int STRING_VALUE = 0;
    public static final int BOOLEAN_VALUE = 1;
    public static final int INTEGER_VALUE = 2;
    public static final int REFERENCE_VALUE = 3;
    public static final int ENUMERATION_VALUE = 4;
    public static final int DOUBLE_VALUE = 5;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Type[]{STRING, BOOLEAN, INTEGER, REFERENCE, ENUMERATION, DOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return BOOLEAN;
            }
            case 2: {
                return INTEGER;
            }
            case 3: {
                return REFERENCE;
            }
            case 4: {
                return ENUMERATION;
            }
            case 5: {
                return DOUBLE;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

