/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.runtime.preferences.ContextDescriptor;
import org.eclipse.papyrus.views.properties.runtime.preferences.Preferences;

class PreferencesMigrator {
    private final ConfigurationManager manager;

    PreferencesMigrator(ConfigurationManager manager) {
        this.manager = manager;
    }

    public boolean process(Preferences preferences) {
        int version = preferences.getVersion();
        if (version < 1 || version > 3) {
            Activator.log.warn(NLS.bind((String)"Unknown version number {0} in Properties View preferences.  Properties view preferences may function erratically or not at all.", (Object)version));
            return false;
        }
        boolean result = false;
        int i = version;
        while (i < 3) {
            this.migrate(preferences, i, i + 1);
            preferences.setVersion(i + 1);
            result = true;
            ++i;
        }
        return result;
    }

    private void migrate(Preferences preferences, int fromVersion, int toVersion) {
        try {
            Method method = this.getClass().getDeclaredMethod(String.format(Locale.ENGLISH, "migrateFrom%dTo%d", fromVersion, toVersion), Preferences.class);
            method.invoke((Object)this, preferences);
        }
        catch (Exception e) {
            Activator.log.error("Failed to invoke migration step.", (Throwable)e);
        }
    }

    void migrateFrom1To2(Preferences preferences) {
        for (ContextDescriptor next : new ArrayList<ContextDescriptor>((Collection<ContextDescriptor>)preferences.getContexts())) {
            if (next.getPrototype() != null || next.isApplied() || this.manager.getContext(next.getName()) != null) continue;
            next.setDeleted(true);
        }
    }

    void migrateFrom2To3(Preferences preferences) {
        for (ContextDescriptor next : new ArrayList<ContextDescriptor>((Collection<ContextDescriptor>)preferences.getContexts())) {
            Context context = this.manager.getContext(next.getName());
            if (context == null) continue;
            if (ConfigurationManager.getInstance().isPlugin(context)) {
                next.setAppliedByDefault(true);
                continue;
            }
            next.setAppliedByDefault(false);
        }
    }
}

