/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.papyrus.views.properties.contexts.Section;

class SectionDiscriminator
implements InvocationHandler {
    private static final Class<?>[] PROXY_INTERFACES = new Class[]{Section.class, EObject.class, InternalEObject.class};
    private final Section section;
    private final Object discriminator;

    SectionDiscriminator(Section section, Object discriminator) {
        this.section = section;
        this.discriminator = discriminator;
    }

    static Section discriminate(Section section, Object discriminator) {
        return (Section)Proxy.newProxyInstance(section.getClass().getClassLoader(), PROXY_INTERFACES, (InvocationHandler)new SectionDiscriminator(section, discriminator));
    }

    static Object getDiscriminator(Section section) {
        InvocationHandler handler;
        Object result = null;
        if (Proxy.isProxyClass(section.getClass()) && (handler = Proxy.getInvocationHandler(section)) instanceof SectionDiscriminator) {
            result = ((SectionDiscriminator)handler).discriminator;
        }
        return result;
    }

    static boolean isDiscriminated(Section section) {
        boolean result = false;
        if (section != null && Proxy.isProxyClass(section.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(section);
            result = handler instanceof SectionDiscriminator;
        }
        return result;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        result = method.getDeclaringClass() == Object.class ? (method.getName().equals("equals") ? (args[0] != null && Proxy.isProxyClass(args[0].getClass()) ? Boolean.valueOf(this.equals(Proxy.getInvocationHandler(args[0]))) : Boolean.valueOf(proxy == args[0])) : (method.getName().equals("hashCode") ? Integer.valueOf(this.hashCode()) : method.invoke((Object)this, args))) : method.invoke((Object)this.section, args);
        return result;
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof SectionDiscriminator) {
            SectionDiscriminator other = (SectionDiscriminator)obj;
            result = other.section == this.section && other.discriminator.equals(this.discriminator);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.discriminator.hashCode();
        result = 31 * result + this.section.hashCode();
        return result;
    }
}

