/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.storage.IContextStorageProvider;
import org.eclipse.papyrus.views.properties.storage.IContextStorageProviderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextStorageProvider
implements IContextStorageProvider {
    private final CopyOnWriteArrayList<IContextStorageProviderListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void initialize(ResourceSet resourceSet) throws CoreException {
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    @Override
    public void refreshContext(Context context) throws CoreException {
    }

    @Override
    public void addContextStorageProviderListener(IContextStorageProviderListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeContextStorageProviderListener(IContextStorageProviderListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireContextsAdded(Collection<? extends Context> contexts) {
        if (!this.listeners.isEmpty() && !contexts.isEmpty()) {
            contexts = Collections.unmodifiableCollection(contexts);
            for (IContextStorageProviderListener next : this.listeners) {
                try {
                    next.contextsAdded(contexts);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in context storage provider listener.", (Throwable)e);
                }
            }
        }
    }

    protected void fireContextsChanged(Collection<? extends Context> contexts) {
        if (!this.listeners.isEmpty() && !contexts.isEmpty()) {
            contexts = Collections.unmodifiableCollection(contexts);
            for (IContextStorageProviderListener next : this.listeners) {
                try {
                    next.contextsChanged(contexts);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in context storage provider listener.", (Throwable)e);
                }
            }
        }
    }

    protected void fireContextsRemoved(Collection<? extends Context> contexts) {
        if (!this.listeners.isEmpty() && !contexts.isEmpty()) {
            contexts = Collections.unmodifiableCollection(contexts);
            for (IContextStorageProviderListener next : this.listeners) {
                try {
                    next.contextsRemoved(contexts);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in context storage provider listener.", (Throwable)e);
                }
            }
        }
    }
}

