/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.storage.workspace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.storage.AbstractContextStorageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceContextStorageProvider
extends AbstractContextStorageProvider {
    private ResourceSet resourceSet;

    @Override
    public void initialize(ResourceSet resourceSet) throws CoreException {
        this.resourceSet = resourceSet;
    }

    @Override
    public boolean providesFor(Context context) {
        Resource resource = context.eResource();
        return resource != null && resource.getURI().isPlatformResource() || resource.getURI().isFile();
    }

    @Override
    public Collection<? extends Context> loadContexts() throws CoreException {
        ArrayList<Context> result = new ArrayList<Context>();
        IPath path = Activator.getDefault().getPreferencesPath();
        File preferencesDirectory = path.toFile();
        File[] fileArray = preferencesDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File contextDirectory = fileArray[n2];
            try {
                Context context;
                if (contextDirectory.isDirectory() && (context = this.loadCustomContext(contextDirectory)) != null) {
                    result.add(context);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
        return result;
    }

    private Context loadCustomContext(File contextDirectory) throws IOException {
        Context result = null;
        String contextPath = String.valueOf(contextDirectory.getPath()) + "/" + contextDirectory.getName() + ".ctx";
        URI contextURI = URI.createFileURI((String)contextPath);
        EObject model = EMFHelper.loadEMFModel((ResourceSet)this.resourceSet, (URI)contextURI);
        if (model instanceof Context) {
            result = (Context)model;
        }
        return result;
    }
}

