/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnDefaultElementStylizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateLabelDecorator;
import org.eclipse.swt.graphics.Image;

public class PapyrusElementStylizer
extends DawnDefaultElementStylizer {
    public Image getImage(Object element, DawnState state) {
        Image result;
        switch (state) {
            case LOCKED_LOCALLY: {
                result = SharedImages.getImage("self_locked_ovr16");
                break;
            }
            case LOCKED_REMOTELY: {
                result = SharedImages.getImage("other_locked_ovr16");
                break;
            }
            case CONFLICT: {
                result = SharedImages.getImage("conflicted_ovr16");
                break;
            }
            default: {
                result = super.getImage(element, state);
            }
        }
        return result;
    }

    public void setDefault(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.setState(eObject, DawnState.CLEAN);
        }
    }

    public void setConflicted(Object element, int type) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            this.setState(eObject, DawnState.CONFLICT);
        }
    }

    public void setLocked(Object element, int type) {
        if (element instanceof EObject) {
            DawnState state;
            EObject eObject = (EObject)element;
            switch (type) {
                case 4: {
                    state = DawnState.LOCKED_REMOTELY;
                    break;
                }
                case 3: {
                    state = DawnState.LOCKED_LOCALLY;
                    break;
                }
                default: {
                    state = DawnState.LOCKED_REMOTELY;
                }
            }
            this.setState(eObject, state);
        }
    }

    protected void setState(EObject object, DawnState state) {
        CDOStateAdapter.setState((Notifier)object, state);
        CDOStateLabelDecorator.fireLabelUpdates();
    }
}

